#include "mbed.h"
#include "BNO055.h"
#include "BME280.h"

DigitalOut m1_dir(p23);
PwmOut m1_duty(p24);
DigitalOut m2_dir(p21);
PwmOut m2_duty(p22);

DigitalOut led1(LED1);
DigitalOut led2(LED2);

Serial pc(USBTX, USBRX);
I2C ifaceI2C(I2C_SDA, I2C_SCL);  //センサー用のI2C
BOARDC_BNO055 sensor1(&ifaceI2C);//センサーで使うI2Cの定義

float pitch, roll;
int i = 1.0;
int k = 0.0;
float p;

int main() 
{    
    char co;
    ifaceI2C.frequency(200000);
    sensor1.initialize(false);
    short dataBox[12];
    float scEUL;
    scEUL = sensor1.getEulerScale();
    
    pc.printf("Chaek Driver.\n");
    
    while(1)
    {
        wait(0.1);
        co=pc.getc();
        pc.putc(co);
        sensor1.get9AxisAndEUL(dataBox);
        roll = (float)dataBox[10] * scEUL;
        pitch = (float)dataBox[11] * scEUL;

        m1_duty.write(p);
        m2_duty.write(p);        
        
    switch(co)
    {
        case'w':
        m1_dir = i;
        m2_dir =1.0 - i ;
        p = 0.95;
        break;
        
        case'd':
        m1_dir = i;
        m2_dir = i;
        p = 0.95;
        break;
        
        case's':
        m1_dir = 1.0 - i;
        m2_dir = i;
        p = 0.95;
        break;
        
        case'a':
        m1_dir = 1.0 - i;
        m2_dir = 1.0 - i;
        p = 0.95;
        break;
        
        case'e':
        p = 0.0;
        break;
        
        case'c':
        pc.printf("%05.4f,%05.4f\n", pitch,roll);
        break;
    }    
}
}