#include "mbed.h"
#include "VSPI.h"

//declaration
VSPI spi(D0, D1, D2, D3);

int main(){

    //SPI freqency 10,000(10KHz) to 1,000,000(1MHz)
    spi.frequency(500000);
    //bits: Number of bits per SPI frame(8 to 32), mode: Clock polarity and phase mode(0 to 3)
    spi.format(32, 0);
    //bit order: MSBfirst = true, LSBfirst = false
    spi.setBitOrder(true);
    //CS mode: Active low(true) -> cs(0),write,cs(1) Active high(false) -> cs(1),write,cs(0)
    spi.setCSmode(false);

    //CS = 0, write, CS = 1
    spi.setCS(0);
    spi.write(0x00FC15BA);
    spi.csInvert();

    //change bit order
    spi.csInvert();
    spi.write(0xCCFFCC00);  // First -> 1100 1100|1111 1111|1100 1100|0000 0000 <- Last
    spi.setBitOrder(false);
    spi.write(0xCCFFCC00);  // Last -> 1100 1100|1111 1111|1100 1100|0000 0000 <- First
    spi.setBitOrder(true);
    spi.csInvert();

    //Write with setCS: CS = 1,write,CS = 0
    spi.wwcs(0x00FF00AA);

    //Write with setCS(wait): CS = 0,wait_us(3),write,wait_us(3),CS = 1
    spi.setCSmode(true);
    spi.wwcs(0x00FF00AA, 3);

}
