#include "mbed.h"

#ifndef VSPI_H
#define VSPI_H

class VSPI{
public:
    VSPI(PinName mosi, PinName sclk);
    VSPI(PinName mosi, PinName miso, PinName sclk);
    VSPI(PinName mosi, PinName miso, PinName sclk, PinName csel);

private:
    DigitalOut *mo;
    DigitalIn *mi;
    DigitalOut *cl;
    DigitalOut *cs;

    bool hasInput;
    bool hasSelect;

    unsigned int freq;
    unsigned int w_us;
    unsigned char mode;
    unsigned char bits;

    bool activeLow;
    bool msbf;

    bool isHigh;

public:
    void format(unsigned char bits, unsigned char mode = 0);
    void frequency(unsigned int hz = 1000000);
    int write(int value);
    int wwcs(int value);
    int wwcs(int value, unsigned int waitMicros);
    void setBitOrder(bool isMSBfirst = true);
    void setCSmode(bool isActiveLow = true);
    void setCS(bool H);
    bool getCS();
    bool csInvert();
};

#endif
