#include "mbed.h"
#include "SPLC792A_I2C.h"

DigitalOut myled(LED1);                 //動作確認用LED
DigitalOut rst(D7);                     //rstはVDDに接続してHIGH状態を保てれば良い
LCDI2C_SPLC792A lcd(I2C_SDA, I2C_SCL);  //LCDI2C_SPLC792Aをlcdという名前でインスタンス化

int main(){
    //動作遅延用
    wait(10);
    rst = 1;
    wait_us(200);

    //lcd初期化
    rst = 0;
    wait_us(200);
    rst = 1;
    wait_us(200);
    lcd.init();

    //動作確認用LED点灯
    myled = 1;

    lcd.setContrast(4, 40);                 //液晶の表示濃度を設定
    lcd.cls();                              //液晶表示クリア
    lcd.writeString("aitendo \\375 LCD");   //aitendoの宣伝
    lcd.setCursorfromColRow(1, 2);          //2行目の1桁目に移動

    //表示(writeString, print, write, o はすべて同じ関数のエイリアス)
    lcd.print("mbed");                      //mbedと表示
    lcd.write(" SPLC");                     // SPLCと表示
    lcd.o("792A");                          //792Aと表示

    //意味もなく5秒待つ
    wait(5);

    //画面クリア、 座標を1, 1に
    lcd.cls();
    lcd.setCursor(1, 1);

    //表示用文字列宣言
    char str[] = "Institute of Electrical and Electronics Engineers = IEEE ";

    //宣言した文字を1文字あたり500msで出力する(空白は2倍の1000ms)
    lcd.print(str, 500);

    //動作確認用LED消灯
    myled = 0;
}
