/*
文字列に日本語を記述すると、コンパイルの段階でmultibyte関連の
warningが大量に生成されますが、使用上問題ありません。
(errorにはなりません)
--------------------------------------------------------------------
TIPS:
文字列に日本語フォントを使用せず、英数字のみを使用する場合は
MPLUS12.txtの#define MP12_USE_ZENKAKUをコメントアウトしてください。
これにより、binファイルのサイズを210Kbyteをほど削減できます。
{
    オンラインコンパイラ上で上記作業を実施した場合は、
    コミットやパブリッシュなどの操作にご注意ください。
    (私もあまりよくわかっていません)
    普通のコンパイルや保存はとくに問題ありません。
}
*/

#include "mbed.h"
#include "SH_MLCD_J.h"

SHMLCD_J mlcd(p26, p25, p24);

int main(){

    //初期化(引数にはデータシートに書いてある表示横幅と表示高さを指定する)
    mlcd.init(400, 240);

    //四角形(即時描画)
    mlcd.drawRect(15, 15, 20, 20, SHMLCD_J_BLACK, true);
    mlcd.drawRect2(45, 15, 65, 35, SHMLCD_J_BLACK, true);
    mlcd.fillRect(75, 15, 20, 20, SHMLCD_J_BLACK, true);
    mlcd.fill2Point(105, 15, 125, 35, SHMLCD_J_BLACK, true);

    //円(あとで描画):第5引数がfalseだと即時描画しない
    mlcd.drawCircle(25, 55, 10, SHMLCD_J_BLACK, false);
    mlcd.fillCircle(55, 55, 10, SHMLCD_J_BLACK, false);

    //小さい文字(あとで描画):第5引数がfalseだと即時描画しない
    char str1[] = "small text! 小さい文字は余裕。\n改行も有効です。タブは無理。";
    mlcd.ws(str1, 10, 80, SHMLCD_J_BLACK, false);

    //大きい文字(即時描画):第4引数にズーム倍率(整数)で倍角可能
    char str2[] = "Large Text! ２倍角も余裕。";
    mlcd.ws(str2, 10, 160, 2, SHMLCD_J_BLACK, true);

    wait(3.0);

    //表示画素全部更新(ここで円と小さい文字が描画されます)
    mlcd.writeArrayA();

    wait(3.0);

    //設定された表示幅と高さを取得
    int width_size = mlcd.getWidth();
    int height_size = mlcd.getHeight();

    //グリッドを表示
    //垂直線を等間隔にXOR表示(描画はあとで):第4引数は描画モード
    //描画モード(fillCircleはSHMLCD_J_INVERTが使えません)：
    // SHMLCD_J_BLACK (0): 黒で描画します
    // SHMLCD_J_ERASE (1): 白で描画します
    // SHMLCD_J_INVERT (-1): 画素を反転(XOR)させます(白なら黒、黒なら白)
    for(int x=10; x<width_size; x+=20){
        mlcd.drawLine(x, 0, x, height_size-1, SHMLCD_J_INVERT, false);
    }
    //水平線を等間隔にXOR表示(描画はあとで):第4引数は描画モード
    for(int y=10; y<height_size; y+=20){
        mlcd.drawLine(0, y, width_size-1, y, SHMLCD_J_INVERT, false);
    }

    //表示画素特定部分だけ更新:ライン80からライン160まで更新
    mlcd.writeArrayN(80, 160);

    wait(3.0);

    //表示画素全部更新
    mlcd.writeArrayA();
}
