#include "mbed.h"
#include "L6470SDC.h"

int main(){
    //インスタンス化
    //USBシリアルとSPIとCSのピン別名を渡す
    L6470SDC l6470(USBTX, USBRX, SPI_MOSI, SPI_MISO, SPI_SCK, D10);

    wait(1);

    //L6470ドライバーの初期化
    l6470.init();

    wait(5);

    //1番目のモーターの最大速度を毎秒100ステップに設定
    l6470.setMaximumSpeed(1, l6470.calcMaxSpd(100));
    //2番目のモーターの最大速度を毎秒200ステップに設定
    l6470.setMaximumSpeed(2, l6470.calcMaxSpd(200));

    //1番目と2番目のモーターを5秒回転させる
    //最大速度は毎秒300ステップ
    //キューを介して実行していないので、開始タイミングがズレる
    l6470.run(1, l6470.calcSpd(300), true); //1番は時計回り
    l6470.run(2, l6470.calcSpd(300), false); //2番は反時計回り
    wait(5.0);
    l6470.stop(1);
    l6470.stop(2);

    //モーターが完全停止するまで待つ
    while(l6470.isBusy(1) || l6470.isBusy(2));

    //動きが早すぎるので人間が追い付くための待ち時間
    wait(3.0);

    //実行キューに追加:1番目のモーター7回転(1回転200ステップ×マイクロステップ数×7)、時計回り
    l6470.ENQ_move(1, 200*128*7, true);

    //実行キューに追加:2番目のモーター7回転(1回転200ステップ×マイクロステップ数×7)、時計回り
    l6470.ENQ_move(2, 200*128*7, true);

    //キューを実行
    l6470.Qexec();

    //モーターが回転を終えるまで待つ
    //2番目のモーターは1番目の2倍の速度で動くため、待ち続けることになる
    while(l6470.isBusy(1) || l6470.isBusy(2));

    //1番目のモーターの最大速度を2番目と同一に設定
    l6470.setMaximumSpeed(1, l6470.getMaximumSpeed(2));

    //それぞれのモーターの初期位置に戻る(zeroとhomeは別名の同一関数)
    l6470.home(1);
    l6470.zero(2);
}
