/* Copyright (c) 2016 Yajirushi(Cursor)
 *
 * Released under the MIT license
 * http://opensource.org/licenses/mit-license.php
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#include "mbed.h"

#ifndef DRV8301CTRL_H
#define DRV8301CTRL_H

// ##### BEGIN:ここからユーザーが変更する部分(Change setting, if you need.) ####

//DRV8301 SPI FREQUENCY(SPIの周波数：Max=5MHz)
#define DRV8301CTRL_FREQ 1000000

// ##### END:ここまで                                                      #####

//STATUS & CONTROL REGISTERS
#define DRV8301REG_WRITEMODE 0x0000
#define DRV8301REG_READMODE 0x8000
#define DRV8301REG_STATUS1 0x0000
#define DRV8301REG_STATUS2 0x0800
#define DRV8301REG_CTRL1 0x1000
#define DRV8301REG_CTRL2 0x1800

//ENUM STATUS & CONTROL VALUES
enum CTRL1_GATE_CURRENT{
    GATE_CURRENT_PEAKCURRENT_1_7A = 0x0000,
    GATE_CURRENT_PEAKCURRENT_0_7A = 0x0001,
    GATE_CURRENT_PEAKCURRENT_0_25A = 0x0002,
    GATE_CURRENT_PEAKCURRENT_RESERVED = 0x0003
};
enum CTRL1_GATE_RESET{
    GATE_RESET_NORMAL = 0x0000,
    GATE_RESET_RESETGATE_LATCHED_FAULT = 0x0004
};
enum CTRL1_PWM_MODE{
    PWM_MODE_PWMLINES_6 = 0x0000,
    PWM_MODE_PWMLINES_3 = 0x0008
};
enum CTRL1_OCP_MODE{
    OCP_MODE_CURRENTLIMIT = 0x0000,
    OCP_MODE_OC_LATCH_SHUTDOWN = 0x0010,
    OCP_MODE_REPORTONLY = 0x0020,
    OCP_MODE_OC_DISABLE = 0x0030
};
enum CTRL1_OC_ADJ{
    OC_ADJ_SET_ADJUST_0_060=0x0000,
    OC_ADJ_SET_ADJUST_0_068=0x0040,
    OC_ADJ_SET_ADJUST_0_076=0x0080,
    OC_ADJ_SET_ADJUST_0_086=0x00C0,
    OC_ADJ_SET_ADJUST_0_097=0x0100,
    OC_ADJ_SET_ADJUST_0_109=0x0140,
    OC_ADJ_SET_ADJUST_0_123=0x0180,
    OC_ADJ_SET_ADJUST_0_138=0x01C0,
    OC_ADJ_SET_ADJUST_0_155=0x0200,
    OC_ADJ_SET_ADJUST_0_175=0x0240,
    OC_ADJ_SET_ADJUST_0_197=0x0280,
    OC_ADJ_SET_ADJUST_0_222=0x02C0,
    OC_ADJ_SET_ADJUST_0_250=0x0300,
    OC_ADJ_SET_ADJUST_0_282=0x0340,
    OC_ADJ_SET_ADJUST_0_317=0x0380,
    OC_ADJ_SET_ADJUST_0_358=0x03C0,
    OC_ADJ_SET_ADJUST_0_403=0x0400,
    OC_ADJ_SET_ADJUST_0_454=0x0440,
    OC_ADJ_SET_ADJUST_0_511=0x0480,
    OC_ADJ_SET_ADJUST_0_576=0x04C0,
    OC_ADJ_SET_ADJUST_0_648=0x0500,
    OC_ADJ_SET_ADJUST_0_730=0x0540,
    OC_ADJ_SET_ADJUST_0_822=0x0580,
    OC_ADJ_SET_ADJUST_0_926=0x05C0,
    OC_ADJ_SET_ADJUST_1_043=0x0600,
    OC_ADJ_SET_ADJUST_1_175=0x0640,
    OC_ADJ_SET_ADJUST_1_324=0x0680,
    OC_ADJ_SET_ADJUST_1_491=0x06C0,
    OC_ADJ_SET_ADJUST_1_679=0x0700,
    OC_ADJ_SET_ADJUST_1_892=0x0740,
    OC_ADJ_SET_ADJUST_2_131=0x0780,
    OC_ADJ_SET_ADJUST_2_400=0x07C0
};
enum CTRL2_OCTW_MODE{
    OCTW_MODE_REPORT_OT_OC_BOTH = 0x0000,
    OCTW_MODE_REPORT_OVERTEMP_ONLY = 0x0001,
    OCTW_MODE_REPORT_OVERCURRENT_ONLY = 0x0002,
    OCTW_MODE_REPORT_RESERVED = 0x0003
};
enum CTRL2_SHUNTGAIN{
    SHUNTGAIN_GAIN_10V_PER_V = 0x0000,
    SHUNTGAIN_GAIN_20V_PER_V = 0x0004,
    SHUNTGAIN_GAIN_40V_PER_V = 0x0008,
    SHUNTGAIN_GAIN_80V_PER_V = 0x000C
};
enum CTRL2_DC_CAL_CH1{
    DC_CAL_CH1_ENABLE = 0x0000,
    DC_CAL_CH1_DISABLE = 0x0010
};
enum CTRL2_DC_CAL_CH2{
    DC_CAL_CH2_ENABLE = 0x0000,
    DC_CAL_CH2_DISABLE = 0x0020
};
enum CTRL2_OC_TOFF{
    OC_TOFF_CYCLE_BY_CYCLE = 0x0000,
    OC_TOFF_OFF_TIME_CONTROL = 0x0040
};

//DRV8301 Control Class ========================================================
class drv8301ctrl{
public:
    //Constructor (Overload +3)
    drv8301ctrl(Serial *serial, SPI *spi, PinName csel, PinName en_gate);
    drv8301ctrl(Serial *serial, SPI *spi, DigitalOut *csel, DigitalOut *en_gate);
    drv8301ctrl(SPI *spi, PinName csel, PinName en_gate);
    drv8301ctrl(SPI *spi, DigitalOut *csel, DigitalOut *en_gate);

    //Destructor
    ~drv8301ctrl();

private:
    Serial *pc;
    SPI *si;
    DigitalOut *cs, *gate;

    bool hasSerial;
    unsigned short writeValue1, writeValue2;
    unsigned char devID;

    //SPI read/write command
    int spi_cmd(int val, bool debug=true);

public:

    //initialize:初期化
    void init(bool reset_iface=true);

    //read status register1:(ステータスレジスタ1の読み取り)
    //FAULT, GVDD_UV, PVDD_UV, OTSD, OTW,
    //FETHA_OC, FETLA_OC, FETHB_OC, FETLB_OC, FETHC_OC, FETLC_OC
    unsigned short readStatus1();

    //read status register2:(ステータスレジスタ2の読み取り)
    //GVDD_OV, DEVICE_ID
    unsigned short readStatus2();

    //read status:FAULT
    bool readFault();
    //read status:GVDD_UV(GVDD under voltage)
    bool readGVDD_UV();
    //read status:PVDD_UV(PVDD under voltage)
    bool readPVDD_UV();
    //read status:OTSD(Over Temperature ShutDown: over 150 degree C)
    bool readOTSD();
    //read status:OTW(Over Temperature Warning: over 130 degree C)
    bool readOTW();
    //read status:FETHA_OC(MOSFET A High-Side Over Current: ref OC_ADJ)
    bool readFETHA_OC();
    //read status:FETLA_OC(MOSFET A Low-Side Over Current: ref OC_ADJ)
    bool readFETLA_OC();
    //read status:FETHB_OC(MOSFET B High-Side Over Current: ref OC_ADJ)
    bool readFETHB_OC();
    //read status:FETLB_OC(MOSFET B Low-Side Over Current: ref OC_ADJ)
    bool readFETLB_OC();
    //read status:FETHC_OC(MOSFET C High-Side Over Current: ref OC_ADJ)
    bool readFETHC_OC();
    //read status:FETLC_OC(MOSFET C Low-Side Over Current: ref OC_ADJ)
    bool readFETLC_OC();
    //read status:GVDD_OV(GVDD over voltage)
    bool readGVDD_OV();
    //read status:DEVICE_ID
    unsigned char readDEVICE_ID();

    //read control register1:(コントロールレジスタ1の読み取り)
    //GATE_CURRENT, GATE_RESET, PWM_MODE, OCP_MODE, OC_ADJ_SET
    unsigned short readCtrl1();

    //read control register2:(コントロールレジスタ2の読み取り)
    //OCTW_MODE, GAIN, DC_CAL_CH1, DC_CAL_CH2, OC_TOFF
    unsigned short readCtrl2();

    //read settings:GATE_CURRENT(MOSFET Gate drive peak current)
    unsigned char readGATE_CURRENT(); //HexValue
    float readValGATE_CURRENT(); //RealValue
    //read settings:GATE_RESET(MOSFET Gate reset mode)
    bool readGATE_RESETisNormal();
    //read settings:PWM_MODE(6-pwm or 3-pwm)
    bool readPWM_MODEis6PWM();
    //read settings:OCP_MODE(Over Current Protection mode)
    unsigned char readOCP_MODE();
    //read settings:OC_ADJ_SET(Over Curent Adjust set)
    unsigned char readOC_ADJ_SET(); //HexValue
    float readValOC_ADJ_SET(); //RealValue
    //read settings:OCTW_MODE(Over Current and Temperature Warning mode)
    unsigned char readOCTW_MODE();
    //read settings:GAIN(Shunt amp gain)
    unsigned char readGAIN();
    //read settings:DC_CAL_CH1(Calibration Shunt amp CH-1)
    bool readDC_CAL_CH1isEnabled();
    //read settings:DC_CAL_CH2(Calibration Shunt amp CH-2)
    bool readDC_CAL_CH2isEnabled();
    //read settings:OC_TOFF(Over Current MOSFET gate off mode)
    bool readOC_TOFFisCycleByCycle();

    //write control register1:(コントロールレジスタ1へ書き込み)
    bool writeCtrl1(unsigned short val=0xffff);

    //write control register2:(コントロールレジスタ2へ書き込み)
    bool writeCtrl2(unsigned short val=0xffff);

    //writeValue clear:(内部に保持しているレジスタの仮の値を消去)
    void resetWriteValue1();
    void resetWriteValue2();

    //writeValue direct update:(内部に保持しているレジスタの仮の値を更新)
    void updateWriteValue1(unsigned short val);
    void updateWriteValue2(unsigned short val);

    //set value:GATE_CURRENT(MOSFET Gate drive peak current)
    void setGATE_CURRENT(unsigned char hexVal);
    void setGATE_CURRENT(float realVal);
    //set value:GATE_RESET(MOSFET Gate reset mode)
    void setGATE_RESET(bool isNormal);
    //set value:PWM_MODE(6-pwm or 3-pwm)
    void setPWM_MODE(bool is6PWM);
    //set value:OCP_MODE(Over Current Protection mode)
    void setOCP_MODE(unsigned char val);
    //set value:OC_ADJ_SET(Over Curent Adjust set)
    void setOC_ADJ(unsigned char hexVal);
    void setOC_ADJ(float realVal);
    //set value:OCTW_MODE(Over Current and Temperature Warning mode)
    void setOCTW_MODE(unsigned char val);
    //set value:GAIN(Shunt amp gain)
    void setGAIN(unsigned char val);
    //set value:DC_CAL_CH1(Calibration Shunt amp CH-1)
    void setDC_CAL_CH1_Enabled(bool enable);
    //set value:DC_CAL_CH2(Calibration Shunt amp CH-2)
    void setDC_CAL_CH2_Enabled(bool enable);
    //set value:OC_TOFF(Over Current MOSFET gate off mode)
    void setOC_TOFF_CycleByCycle(bool enable);

    //EN_GATE on,off:(EN_GATEピンの状態セット)
    void gateEnable();
    void gateDisable();
    void gateReset();
};

#endif
