#ifndef BME280_H
#define BME280_H

#include "mbed.h"

//I2Cデフォルトスレーブアドレス
#define BME280_I2C_DEFADDR  0x76
//SPIデフォルト通信スピード[Hz]
#define BME280_SPI_DEFSPD   3000000

#define BME280R_ID          0xD0

#define BME280R_RESET       0xE0
#define BME280R_CTRL_HUM    0xF2
#define BME280R_STATUS      0xF3
#define BME280R_CTRL_MEAS   0xF4
#define BME280R_CONFIG      0xF5

#define BME280R_PRESS_MSB   0xF7
#define BME280R_PRESS_LSB   0xF8
#define BME280R_PRESS_XLSB  0xF9

#define BME280R_TEMP_MSB    0xFA
#define BME280R_TEMP_LSB    0xFB
#define BME280R_TEMP_XLSB   0xFC

#define BME280R_HUM_MSB     0xFD
#define BME280R_HUM_LSB     0xFE

#define BME280R_CALIB00     0x88
#define BME280R_CALIB01     0x89
#define BME280R_CALIB02     0x8A
#define BME280R_CALIB03     0x8B
#define BME280R_CALIB04     0x8C
#define BME280R_CALIB05     0x8D
#define BME280R_CALIB06     0x8E
#define BME280R_CALIB07     0x8F
#define BME280R_CALIB08     0x90
#define BME280R_CALIB09     0x91
#define BME280R_CALIB10     0x92
#define BME280R_CALIB11     0x93
#define BME280R_CALIB12     0x94
#define BME280R_CALIB13     0x95
#define BME280R_CALIB14     0x96
#define BME280R_CALIB15     0x97
#define BME280R_CALIB16     0x98
#define BME280R_CALIB17     0x99
#define BME280R_CALIB18     0x9A
#define BME280R_CALIB19     0x9B
#define BME280R_CALIB20     0x9C
#define BME280R_CALIB21     0x9D
#define BME280R_CALIB22     0x9E
#define BME280R_CALIB23     0x9F
#define BME280R_CALIB24     0xA0
#define BME280R_CALIB25     0xA1

#define BME280R_CALIB26     0xE1
#define BME280R_CALIB27     0xE2
#define BME280R_CALIB28     0xE3
#define BME280R_CALIB29     0xE4
#define BME280R_CALIB30     0xE5
#define BME280R_CALIB31     0xE6
#define BME280R_CALIB32     0xE7
#define BME280R_CALIB33     0xE8
#define BME280R_CALIB34     0xE9
#define BME280R_CALIB35     0xEA
#define BME280R_CALIB36     0xEB
#define BME280R_CALIB37     0xEC
#define BME280R_CALIB38     0xED
#define BME280R_CALIB39     0xEE
#define BME280R_CALIB40     0xEF
#define BME280R_CALIB41     0xF0

class BME280_CTRL{
public:
    BME280_CTRL();
    virtual ~BME280_CTRL();
protected:
    char interface_mode;
public:
    char getInterfaceMode();
    virtual void init();
    virtual char rr(char regAddr);
    virtual char rrc(char startRegAddr, char *receiveBytes, char length);
    virtual char wr(char regAddr, char wBytes);
};

class BME280_SPI_CTRL : public BME280_CTRL{
public:
    BME280_SPI_CTRL(SPI *si, DigitalOut *spi_cs, unsigned int speedHz);
    virtual ~BME280_SPI_CTRL();
private:
    SPI *iface;
    DigitalOut *cs;
    unsigned int speed;
public:
    virtual void init();
    virtual char rr(char regAddr);
    virtual char rrc(char startRegAddr, char *receiveBytes, char length);
    virtual char wr(char regAddr, char wBytes);
};

class BME280_I2C_CTRL : public BME280_CTRL{
public:
    BME280_I2C_CTRL(I2C *iic, char addr, unsigned int freq);
    virtual ~BME280_I2C_CTRL();
private:
    I2C *iface;
    char i2c_readAddr;
    char i2c_writeAddr;
    unsigned int i2c_freq;
public:
    virtual void init();
    virtual char rr(char regAddr);
    virtual char rrc(char startRegAddr, char *receiveBytes, char length);
    virtual char wr(char regAddr, char wBytes);
};

class BOARDC_BME280{
public:
    BOARDC_BME280(PinName mosi, PinName miso, PinName sck, PinName scs, unsigned int spdHz=BME280_SPI_DEFSPD);
    BOARDC_BME280(SPI *spi, PinName scs, unsigned int spdHz=BME280_SPI_DEFSPD);
    BOARDC_BME280(SPI *spi, DigitalOut *spi_cs, unsigned int spdHz=BME280_SPI_DEFSPD);

    BOARDC_BME280(PinName sda, PinName scl, char addr=BME280_I2C_DEFADDR, unsigned int freq=100000);
    BOARDC_BME280(I2C *iic, char addr=BME280_I2C_DEFADDR, unsigned int freq=100000);
private:
    BME280_CTRL *ctrl;

    signed int t_fine;

    unsigned short T1;
    signed short T2;
    signed short T3;

    unsigned short P1;
    signed short P2;
    signed short P3;
    signed short P4;
    signed short P5;
    signed short P6;
    signed short P7;
    signed short P8;
    signed short P9;

    unsigned char H1;
    signed short H2;
    unsigned char H3;
    signed short H4;
    signed short H5;
    signed char H6;
public:
    void initialize(bool initIface=true);

    char getInterfaceMode();

    char getChipID();

    void reset();

    char getCTRL_humidity();
    void setCTRL_humidity(char regVal);

    char getCTRL_measuring();
    void setCTRL_measuring(char regVal);

    unsigned int getOverSample_P();
    unsigned int getOverSample_T();
    unsigned int getOverSample_H();
    void setOverSample_P(unsigned int oversampling);
    void setOverSample_T(unsigned int oversampling);
    void setOverSample_H(unsigned int oversampling);

    char getConfig();
    void setConfig(char regVal);

    char getStatus();
    bool isReady();

    char getMode();

    void updateCalib();
    void updateCalibT();
    void updateCalibP();
    void updateCalibH();

    float getTemp(unsigned int mode=0);
    float getTemp_Celsius();
    float getTemp_Fahrenheit();
    float getTemp_Kelvin();

    float getPress(unsigned int mode=0);
    float getPress_Pascal();
    float getPress_hPa();
    float getPress_psi();

    float getHum();

    double getPress64(unsigned int mode=0);
    double getPress64_Pascal();
    double getPress64_hPa();
    double getPress64_psi();
};

#endif
