#include "mbed.h"

#include "BNO055.h"
#include "BME280.h"

//PCへのシリアル通信
Serial pc(USBTX, USBRX);

//mbed Nucleoのユーザーボタン
DigitalIn btn(USER_BUTTON);

//mbed LED1
DigitalOut led(LED1);

//両方のセンサーに使用するI2C
I2C ifaceI2C(I2C_SDA, I2C_SCL);

//RawSerial ifaceUART(D8, D2); //BNO055にUARTを使う場合
//SPI ifaceSPI(SPI_MOSI, SPI_MISO, SPI_SCK); //BME280にSPIを使う場合
//DigitalOut scs(D7); //BME280にSPIを使う場合

//両方のセンサーをI2Cで使用する
BOARDC_BNO055 sensor1(&ifaceI2C);
BOARDC_BME280 sensor2(&ifaceI2C);

//BOARDC_BNO055 sensor1(&ifaceUART); //BNO055にUARTを使う場合
//BOARDC_BME280 sensor2(&ifaceSPI, &scs); //BME280にSPIを使う場合

int main(){

    //挨拶表示
    pc.printf("mbed READY\r\n");

    while(btn); //ボタンが押されるまで待ち続ける(Nucleo専用)

    wait_ms(1000);
    led = 1;

    pc.printf("Start Comm - -- ---- --------\r\n");

    //I2Cインターフェースで２つのセンサーを使用する(200KHz)
    ifaceI2C.frequency(200000);
    sensor1.initialize(false);
    sensor2.initialize(false);

    //それぞれのセンサーを独立して使用する場合は、initialize関数の引数をtrue(または引数なし)にすることで自動設定する
    //sensor1.initialize();
    //sensor2.initialize();

    //各センサーのチップIDなどを表示するステートメント
    {
        char chipID = sensor1.getChipID();
        char AccChipID = sensor1.getAccChipID();
        char MagChipID = sensor1.getMagChipID();
        char GyroChipID = sensor1.getGyroChipID();
        char bootLoader = sensor1.getBootRevision();

        char bme280chip = sensor2.getChipID();

        pc.printf("BNO055 (9DOF sensor) ---- ---- ---- ---- ---- ---- ---- ---- ----\r\n");
        pc.printf("chipID = 0x%02X, bootLoader = %d\r\n", chipID, bootLoader);
        pc.printf("Acc    = 0x%02X\r\nMag    = 0x%02X\r\nGyro   = 0x%02X\r\n\r\n", AccChipID, MagChipID, GyroChipID);

        pc.printf("BME280 (Temperature, Humidity, Pressure sensor) -- ---- ---- ----\r\n");
        pc.printf("chipID = 0x%02X\r\n\r\n", bme280chip);

    }

    while(btn); //ボタンが押されるまで待ち続ける(Nucleo専用)

    wait_ms(1000);
    led = 0;

    //各センサーの現在の設定などを表示するステートメント
    {
        char mode = sensor1.getOperationMode();
        char sysStatus = sensor1.getSystemStatus();
        char testStatus = sensor1.getSelfTestResultAll();
        char errorStatus = sensor1.getSystemError();
        char calibST[4];
        sensor1.getCalibStatusAll(calibST[0], calibST[1], calibST[2], calibST[3]);

        char bme280mode_hum = sensor2.getCTRL_humidity();
        char bme280mode_meas = sensor2.getCTRL_measuring();
        char bme280mode_conf = sensor2.getConfig();

        pc.printf("BNO055 (9DOF sensor) ---- ---- ---- ---- ---- ---- ---- ---- ----\r\n");
        pc.printf("Mode = 0x%02X, sysStatus = 0x%02X, testStatus = 0x%02X\r\n", mode, sysStatus, testStatus);
        pc.printf("calibSys = %d [%%], calibAcc = %d [%%], calibMag = %d [%%], calibGyro = %d [%%]\r\n", calibST[0], calibST[1], calibST[2], calibST[3]);
        pc.printf("errorStatus = 0x%02X, err = 0x%02X, len = %d\r\n\r\n", errorStatus, sensor1.getIfaceLastError(), sensor1.getIfaceLastLength());

        pc.printf("BME280 (Temperature, Humidity, Pressure sensor) -- ---- ---- ----\r\n");
        pc.printf("CTRL_HUM = 0x%02X, CTRL_MEAS = 0x%02X, CONFIG = 0x%02X\r\n\r\n", bme280mode_hum, bme280mode_meas, bme280mode_conf);
    }

    while(btn); //ボタンが押されるまで待ち続ける(Nucleo専用)

    wait_ms(1000);
    led = 1;

    //各センサーの値を格納するための変数宣言
    short dataBox[12];
    float scAcc, scMag, scGyro, scEUL, scTemp;
    float ax, ay, az, mx, my, mz, gx, gy, gz, yaw, roll, pitch, temp;
    float bme280_T = 0.0, bme280_P = 0.0, bme280_H = 0.0;
    char bme280_status = 0x00;

    //センサーのRAW値を実際の数値に変換するための倍率を取得する
    scAcc = sensor1.getAccScale();
    scMag = sensor1.getMagScale();
    scGyro = sensor1.getGyroScale();
    scEUL = sensor1.getEulerScale();
    scTemp = sensor1.getTempScale();

    //ボタンが押されるまで繰り返し続ける(Nucleo専用)
    //ボタンがない場合はwhile(1)の無限ループで代用
    while(btn){
        //配列dataBoxに、9軸の値とオイラー角(yaw roll pitch)を格納(計12個の値)
        sensor1.get9AxisAndEUL(dataBox);

        //倍率をかけてRaw値を実際の値に変換
        ax = (float)dataBox[0] * scAcc;
        ay = (float)dataBox[1] * scAcc;
        az = (float)dataBox[2] * scAcc;
        mx = (float)dataBox[3] * scMag;
        my = (float)dataBox[4] * scMag;
        mz = (float)dataBox[5] * scMag;
        gx = (float)dataBox[6] * scGyro;
        gy = (float)dataBox[7] * scGyro;
        gz = (float)dataBox[8] * scGyro;
        yaw = (float)dataBox[9] * scEUL;
        roll = (float)dataBox[10] * scEUL;
        pitch = (float)dataBox[11] * scEUL;

        //BNO055内のセンサーの参考温度を取得して実際の値に変換
        temp = (float)sensor1.getTemperature() * scTemp;

        //温湿度センサーより、温度、湿度、気圧、現在の状態を取得して変数に格納
        bme280_T = sensor2.getTemp();
        bme280_P = sensor2.getPress_hPa();
        bme280_H = sensor2.getHum();
        bme280_status = sensor2.getStatus();

        //温湿度センサーの補正データが更新されていたなら、計算用数値を更新
        if(sensor2.isReady()){
            sensor2.updateCalib();
        }

        pc.printf(
            "Acc = X[%06.5f], Y[%06.5f], Z[%06.5f]\r\nMag = X[%06.5f], Y[%06.5f], Z[%06.5f]\r\nGyr = X[%06.5f], Y[%06.5f], Z[%06.5f]\r\n",
            ax, ay, az, mx, my, mz, gx, gy, gz
        );

        pc.printf(
            "yaw\t\t = %05.4f[deg], data = %0d\r\nroll\t\t = %05.4f[deg], data = %0d\r\npitch\t\t = %05.4f[deg], data = %0d\r\n",
            yaw, dataBox[9], roll, dataBox[10], pitch, dataBox[11]
        );

        pc.printf(
            "Temperature\t = %03.3f[degC] (BNO055 -> %03.3f[degC])\r\nPressure\t = %06.3f[hPa]\r\nHumidity\t = %03.3f[%%RH]\r\nStatus\t = 0x%02X\r\n",
            bme280_T, temp, bme280_P, bme280_H, bme280_status
        );

        wait_ms(1000);
    }
}
