#include "mbed.h"
#include <sstream>

#define MBED_PROJECT "USB3Bug"

UnbufferedSerial pc(USBTX, USBRX, 230400);

struct typeTRANSMISSION { string buffer; string serial; volatile bool SERIAL; } message = { "", "", false };

void serial_event(void);
void fn_processing(string);

int main()
{
    message.buffer.reserve(1024);
    message.serial.reserve(1024);
    pc.attach(callback(&serial_event));
    while(1)
    {
        if(message.SERIAL)
        {
            fn_processing(message.serial);
            message.SERIAL = false;
        }
    }
}

void serial_event(void)
{
    char c;
    pc.read(&c, 1);
    if(c == '\n')
    {
        message.buffer += ';';
        message.serial = message.buffer;
        message.buffer.clear();
        message.SERIAL = true;
    }
    else if((c < 128) && (message.buffer.size() < message.buffer.capacity()-2)) message.buffer += c;
}

void fn_processing(string cmd)
{
    stringstream srecv(cmd), ssend;
    ssend.precision(3);
    while(getline(srecv, cmd, ';'))
    {
        for (unsigned int i = 0; i < cmd.size(); i++) if ((cmd[i] >= 'a') && (cmd[i] <= 'z')) cmd[i] += 'A' - 'a';
        if(ssend.str().size() > 0) ssend << ' ';
        if(cmd.empty());
        else if(cmd == "*IDN?")
        {
            ssend << MBED_PROJECT << ", Mbed OS " << MBED_VERSION << ", Version dated, " << __DATE__ << ", " << __TIME__;
        }
        else if(cmd == "M?")
        {
            ssend << "Motor[" << 0 << "][" << "STOP" << "]";
        }
        else if(cmd == "TRIG?")
        {
            ssend << "Trigger(" << 0 << ")(" << NAN << "V)";
        }
        else if(cmd == "TARG?")
        {
            ssend << "Target[" << 0 << "](" << 4294967295 << ")[" << 0 << "]{" << 0 << "}";
        }
        else if(cmd == "POS?")
        {
            ssend << "Position[" << 0 << "][" << "UNKNOWN" << "](" << 4294967295 << ")";
        }
        else if(cmd.find("?")!=string::npos) ssend << "incorrect requeste [" << cmd << "]";
    }
    if(!ssend.str().empty()) ssend << "\n";
    pc.write(ssend.str().c_str(), ssend.str().length());
}