#ifndef MAIN_H
#define MAIN_H

#define MBED_PROJECT    "TCP-sample"
#define IP_SERVER       "192.168.1.25"
#define PORT_SERVER     80
#define TIMEOUT_SERVER  100
#define BUFFER_SIZE     1072

#include "mbed.h"
#include "EthernetInterface.h"
#include <sstream>

EthernetInterface   eth;
TCPSocket           serverTCP, *clientTCP;
EventQueue          *queue = NULL;
BusOut              Led(LED1, LED2, LED3);

bool CONNECT = false;

enum enum_status { WHITE, CYAN, MAGENTA_ACCEPT, BLUE_CLIENT, YELLOW_CONNECTING, GREEN_GLOBAL_UP, RED_DISCONNECTED, BLACK_INITIALIZE }
    eth_status = RED_DISCONNECTED;

bool            eth_connect(void);
void            eth_event(nsapi_event_t, intptr_t);
void            eth_state(void);

bool            serverTCP_connect(void);
void            serverTCP_event(void);
void            serverTCP_accept(void);

enum_status     recv(void);
nsapi_error_t   send(const string& buff);
#endif