#include "mbed.h"
#include "ssd1963.h"
#include "ASCII12dot.h"
/*
BusOut lcd_bus(D0,D1,D2,D3,D4,D5,D6,D7);
DigitalOut RSout(RS);
DigitalOut RDout(RD);
DigitalOut CSout(CS);
DigitalOut WRout(WR);
DigitalOut RSTout(RST);
*/

TFTout::TFTout(PinName cs,PinName rd,PinName rs,PinName wr,PinName rst,PinName d0,PinName d1,PinName d2,PinName d3,PinName d4,PinName d5,PinName d6,PinName d7) : _CSout(cs), _RDout(rd), _RSout(rs), _WRout(wr), _RSTout(rst), _lcd_bus(d0,d1,d2,d3,d4,d5,d6,d7){
    wait(0.1);//wait until capacira stabilising
    lcd_Init();
    lcd_Clear(0xFFFFFF);          
}

void TFTout::lcd_out(int rs,char data){
    _RDout = 1;
    _RSout = rs;
    _WRout = 0;
    _CSout = 0;
    _lcd_bus = data;
    //for(int i=0;i<10;i++){}
    _CSout = 1;
    _WRout = 1;
}

void TFTout::Command_Write(unsigned char command,unsigned char data1){
    lcd_out(0,command);
    lcd_out(1,data1);
}

void TFTout::SendData(unsigned long color){
    lcd_out(1,(color)>>16);
    lcd_out(1,(color)>>8);
    lcd_out(1,color);
}

void TFTout::WindowSet(unsigned int s_x,unsigned int e_x,unsigned int s_y,unsigned int e_y){
    lcd_out(0,0x2a);
    lcd_out(1,(s_x)>>8);
    lcd_out(1,(s_x));
    lcd_out(1,(e_x)>>8);
    lcd_out(1,(e_x));
    
    lcd_out(0,0x2b);
    lcd_out(1,(s_y)>>8);
    lcd_out(1,(s_y));
    lcd_out(1,(e_y)>>8);
    lcd_out(1,(e_y));
}

void TFTout::lcd_Clear(unsigned long Color){
    unsigned int x,y;
    WindowSet(0x0000,0x01df,0x0000,0x010f);
    lcd_out(0,0x2c);
    for(x=0;x<ENDCOL;x++){
        for (y= 0;y<ENDROW;y++){
            SendData(Color);
        }
    }
}

void TFTout::lcd_Init(void){
    _RSTout = 0;
    wait(0.000001);
    _RSTout = 1;
    wait(0.000001);
    
    lcd_out(0,0x01);            //Software Reset
    lcd_out(0,0x01);
    lcd_out(0,0x01);
    Command_Write(0xe0,0x01);   // START PLL
    Command_Write(0xe0,0x03);   // LOCK PLL
    
    lcd_out(0,0xb0);            //SET LCD MODE SET TFT 18Bits MODE
    lcd_out(1,0x08);            //SET TFT MODE & hsync+Vsync+DEN MODE 
    lcd_out(1,0x00); //SET TFT MODE & hsync+Vsync+DEN MODE
    lcd_out(1,0x01);            //SET horizontal size=480-1 HightByte
    lcd_out(1,0xdf);            //SET horizontal size=480-1 LowByte
    lcd_out(1,0x01);            //SET vertical size=272-1 HightByte
    lcd_out(1,0x0f);            //SET vertical size=272-1 LowByte
    lcd_out(1,0x00);            //SET even/odd line RGB seq.=RGB
    
    Command_Write(0xf0,0x00);   //SET pixel data I/F format=8bit
    Command_Write(0x3a,0x60);   // SET R G B format = 6 6 6
    
    lcd_out(0,0xe2);            //SET PLL freq=113.33MHz ;
    lcd_out(1,0x22);
    lcd_out(1,0x03);
    lcd_out(1,0x04);
    
    lcd_out(0,0xe6);            //SET PCLK freq=9MHz ; pixel clock frequency
    lcd_out(1,0x01);
    lcd_out(1,0x45);
    lcd_out(1,0x47);
    
    lcd_out(0,0xb4);            //SET HBP
    lcd_out(1,0x02);            //SET HSYNC Total = 525
    lcd_out(1,0x0d);
    lcd_out(1,0x00);            //SET HBP = 43
    lcd_out(1,0x2b);
    lcd_out(1,0x28);            //SET VBP 41 = 40 + 1
    lcd_out(1,0x00);            //SET Hsync pulse start position
    lcd_out(1,0x00);
    lcd_out(1,0x00);            //SET Hsync pulse subpixel start position
    
    lcd_out(0,0xb6);            //SET VBP
    lcd_out(1,0x01);            //SET Vsync total 286 = 285 + 1
    lcd_out(1,0x1d);
    lcd_out(1,0x00);            //SET VBP = 12
    lcd_out(1,0x0c);
    lcd_out(1,0x09);            //SET Vsync pulse 10 = 9 + 1
    lcd_out(1,0x00);            //SET Vsync pulse start position
    lcd_out(1,0x00);
    
    lcd_out(0,0x2a);            //SET column address
    lcd_out(1,0x00);            //SET start column address=0
    lcd_out(1,0x00);
    lcd_out(1,0x01);            //SET end column address=480
    lcd_out(1,0xdf);
    
    lcd_out(0,0x2b);            //SET page address
    lcd_out(1,0x00);            //SET start page address=0
    lcd_out(1,0x00);
    lcd_out(1,0x01);            //SET end page address=272
    lcd_out(1,0x0f);
    
    lcd_out(0,0x29);            //SET display on
    lcd_out(0,0x2c);
}

void TFTout::WRITE_PIXEL(int x,int y,unsigned long Color){
    WindowSet(x,x,y,y);
    lcd_out(0,0x2c);
    SendData(Color);
}

//**************************
//  直線描画関数
//**************************
#define abs(a)  (((a)>0) ? (a) : -(a))
void TFTout::lcd_Line(short x0, short y0, short x1, short y1, unsigned long Color)
{
    short steep, t;
    short deltax, deltay, error;
    short x, y;
    short ystep;
    
    y0=ENDROW-y0 -1;                        // Y座標反転
    y1=ENDROW-y1 -1;
    /// 差分の大きいほうを求める
    steep = (abs(y1 - y0) > abs(x1 - x0));
    /// ｘ、ｙの入れ替え
    if(steep){
        t = x0; x0 = y0; y0 = t;
        t = x1; x1 = y1; y1 = t;
    }
    if(x0 > x1) {
        t = x0; x0 = x1; x1 = t;
        t = y0; y0 = y1; y1 = t;
    }
    deltax = x1 - x0;                       // 傾き計算 
    deltay = abs(y1 - y0);
    error = 0;
    y = y0;
    /// 傾きでステップの正負を切り替え
    if(y0 < y1) ystep = 1; else ystep = -1;
    /// 直線を点で描画
    for(x=x0; x<=x1; x++) {
        if(steep) WRITE_PIXEL(y,x,Color); else WRITE_PIXEL(x,y,Color);
        error += deltay;
        if((error << 1) >= deltax) {
            y += ystep;
            error -= deltax;
        }
    }
}
//************************************
//  円を描く関数
//  中心点と半径を指定
//  (Fussyさんのアルゴリズムを使用)
//************************************
void TFTout::lcd_Circle(int x0, int y0, int r, unsigned long color)
{
    int x = r;
    int y = 0;
    int F = -2 * r + 3;
    
    while(x >= y){
        WRITE_PIXEL(x0+x, y0+y, color);
                WRITE_PIXEL(x0-x, y0+y, color);
                WRITE_PIXEL(x0+x, y0-y, color);
                WRITE_PIXEL(x0-x, y0-y, color);
                WRITE_PIXEL(x0+y, y0+x, color);
                WRITE_PIXEL(x0-y, y0+x, color);
                WRITE_PIXEL(x0+y, y0-x, color);
                WRITE_PIXEL(x0-y, y0-x, color);
        if(F >= 0){
            x--;
            F -= 4 * x;
        }
        y++;
        F += 4 * y + 2;
    }
}

//****************************************
// ANK文字表示関数 12x12ドット
// 320/12=26文字/行　240/14=17行
// (0, 0) - (25, 16)の範囲
//****************************************
void TFTout::lcd_Char(char colum, char line, unsigned char letter, unsigned long Color1, unsigned long Color2){
    unsigned char j, i, Mask;

    if((colum < XChar) && (line < YLine)){      // 範囲チェック
        // ANK表示出力　3バイトの2ラインずつを6回繰り返す
        for(j=0; j<6; j++){
            // 8ドット連続部の表示
            Mask = 0x80;
            for(i=0; i<8; i++){
                // １ライン目前半8ドット表示
                if((ANKFont[letter][j*3] & Mask) != 0)
                  WRITE_PIXEL((colum*12)+i+4, (line*14)+(j*2)+2, Color1);
                else
                  WRITE_PIXEL(colum*12+i+4, line*14+j*2+2, Color2);  //背景色
                // 2ライン目後半8ドット表示
                if((ANKFont[letter][j*3+2] & Mask) != 0)
                  WRITE_PIXEL(colum*12+i+8, line*14+j*2+3, Color1);
                else
                  WRITE_PIXEL(colum*12+i+8, line*14+j*2+3, Color2);  //背景色
                Mask = Mask >> 1;
            }
            // 分割部4ドットずつ表示
            Mask = 0x80;
            // 1ライン目後半4ドット表示
            for(i=0; i<4; i++){
                if((ANKFont[letter][j*3+1] & Mask) != 0)
                  WRITE_PIXEL(colum*12+i+12, line*14+j*2+2, Color1);
                else
                  WRITE_PIXEL(colum*12+i+12, line*14+j*2+2, Color2);  //背景色
                Mask = Mask >> 1;
            }
            // 2ライン目前半4ドット表示
            for(i=4; i<8; i++){
                if((ANKFont[letter][j*3+1] & Mask) != 0)
                  WRITE_PIXEL(colum*12+i, line*14+j*2+3, Color1);
                else
                  WRITE_PIXEL(colum*12+i, line*14+j*2+3, Color2);    //背景色
                Mask = Mask >> 1;
            }                           
        }
    }
}

//*****************************
//  文字列描画関数
//  16文字ｘ20行で指定
//****************************/
void TFTout::lcd_Str(char colum, char line, char *s, unsigned long Color1, unsigned long Color2)
{
        while (*s){
        lcd_Char(colum++, line, *s++, Color1, Color2);
        if(colum >= XChar){
            line++;
            colum = 0;
            if(line >= YLine)
                line = 0;
        }
    }
}
