#define D0 p26
#define D1 p27
#define D2 p30
#define D3 p29
#define D4 p28
#define D5 p24
#define D6 p23
#define D7 p22

#define CS p21
#define RD p25
#define RS p19
#define WR p20
#define RST p18

#define ENDCOL          480 // X
#define ENDROW          272 // Y
#define XChar           (short)((ENDCOL) / 12.3)
#define YLine           (short)((ENDROW) / 18)

#ifndef MBED_SSD1963_H
#define MBED_SSD1963_H

class TFTout{
public:
    TFTout(PinName cs,PinName rd,PinName rs,PinName wr,PinName rst,PinName d0,PinName d1,PinName d2,PinName d3,PinName d4,PinName d5,PinName d6,PinName d7);
           
    void lcd_out(int rs,char data);
    void Command_Write(unsigned char command,unsigned char data1);
    void SendData(unsigned long color);
    void WindowSet(unsigned int s_x,unsigned int e_x,unsigned int s_y,unsigned int e_y);
    void WRITE_PIXEL(int x,int y,unsigned long Color);

    void lcd_Init(void);
    void lcd_Clear(unsigned long Color);
    void lcd_Char(char colum, char line, unsigned char letter, unsigned long Color1, unsigned long Color2);
    void lcd_Str(char colum, char line, char *s, unsigned long Color1, unsigned long Color2);
    void lcd_Line(short x0, short y0, short x1, short y1, unsigned long Color);
    void lcd_Circle(int x0, int y0, int r, unsigned long color);
private:       
    DigitalOut _CSout,_RDout,_RSout, _WRout, _RSTout;
    BusOut _lcd_bus;
};

#endif