#ifndef _INC_NMEA0813
#define _INC_NMEA0813
 
#define CR 0x0D
#define LF 0x0A
 
#include "mbed.h"
 
class GPS : public Serial {
public:
    GPS(PinName tx,PinName rx);
    char* get_time();
    float get_latitude();
    char* get_str_latitude();
    float get_longitude();
    char* get_str_longitude();
    char get_status();
    float get_speed();
    int get_satelite_number();
    
private:
    char GPSdata[500];//gps_data_buffer
    char GPGGA[100];//GPGGA_data
    char GPRMC[100];//GPRMC_data
    char time_str[9];
    char latitude_str[10];
    float latitude;
    char longitude_str[11];
    float longitude;
    char status;
    int number_of_satelite;
    char speed_str[6];
    float speed;

    int flg,count;//for rx_func()
    char rxbuf,gga_checksum,rmc_checksum;
    
    void rxHandler(void);
    void update_infomation();
    void set_GGA_RMC(char* str);
    
    Ticker T;
};
    
#endif
 