#include "nmea0813.h"
 
GPS::GPS(PinName tx,PinName rx) : Serial(tx,rx){
    flg = 0;
    count = 0;
    attach(this, &GPS::rxHandler,Serial::RxIrq);
    T.attach(this,&GPS::update_infomation,1.0);
}
 
 
void GPS::rxHandler(void){
    rxbuf = getc();
    GPSdata[count] = rxbuf;
    if(rxbuf == LF){
        flg++;
    }else{}
    count++;
    if(flg == 7){
        flg = 0;
        GPSdata[count+1]='\0';
        count=0;
    }
}

void GPS::update_infomation() { //repeatedlly called function
    set_GGA_RMC(GPSdata);
}

void GPS::set_GGA_RMC(char* str){
    char *sp;
    sp = (char*) strstr(str,"$GPGGA");
    if(sp != NULL){
        for(int i=0;i<100;i++){
            if(sp[i] != '*'){
                GPGGA[i] = sp[i];
            }else{
                GPGGA[i] = '*';
                GPGGA[i+1] = '\0';
                //gga_checksum = sp[i+1]*16+sp[i+2];
                i = 100;
            }          
        }
    }
    sp = (char*) strstr(str,"$GPRMC");
    if(sp != NULL){
        for(int i=0;i<100;i++){
            if(sp[i] != '*'){
                GPRMC[i] = sp[i];
            }else{
                GPRMC[i] = '*';
                GPRMC[i+1] = '\0';
                //rmc_checksum = sp[i+1]*16+sp[i+2];
                i = 100;
            }          
        }  
    } 
}

char* GPS::get_time(){
    time_str[0]=GPGGA[7];
    time_str[1]=GPGGA[8];
    time_str[2]=':';
    time_str[3]=GPGGA[9];
    time_str[4]=GPGGA[10];
    time_str[5]=':';
    time_str[6]=GPGGA[11];
    time_str[7]=GPGGA[12];
    time_str[8]='\0';
    
    return time_str;
}

float GPS::get_latitude(){
    for(int i=0;i<9;i++){latitude_str[i]=GPGGA[18+i];}
    latitude_str[9]='\0';
    latitude = (float)(latitude_str[0]-0x30)*10.0+  \
               (float)(latitude_str[1]-0x30)+       \
               ((float)(latitude_str[2]-0x30)*10.0+ \
               (float)(latitude_str[3]-0x30)+       \
               (float)(latitude_str[5]-0x30)*0.1+   \
               (float)(latitude_str[6]-0x30)*0.01+  \
               (float)(latitude_str[7]-0x30)*0.001+ \
               (float)(latitude_str[8]-0x30)*0.0001)/60.0;
    return latitude;
}

char* GPS::get_str_latitude(){
    for(int i=0;i<9;i++){latitude_str[i]=GPGGA[18+i];}
    latitude_str[9]='\0';
    return latitude_str;
}

float GPS::get_longitude(){
    for(int i=0;i<10;i++){longitude_str[i]=GPGGA[30+i];}
    longitude_str[10]='\0';
    longitude = (float)(longitude_str[0]-0x30)*100.0+ \
               (float)(longitude_str[1]-0x30)*10.0+  \
               (float)(longitude_str[2]-0x30)+       \
               ((float)(longitude_str[3]-0x30)*10.0+ \
               (float)(longitude_str[4]-0x30)+       \
               (float)(longitude_str[6]-0x30)*0.1+   \
               (float)(longitude_str[7]-0x30)*0.01+  \
               (float)(longitude_str[8]-0x30)*0.001+ \
               (float)(longitude_str[9]-0x30)*0.0001)/60.0;
    return longitude;
}

char* GPS::get_str_longitude(){
    for(int i=0;i<10;i++){longitude_str[i]=GPGGA[30+i];}
    longitude_str[10]='\0';
    return longitude_str;
}

char GPS::get_status(){
    status = GPRMC[18];
    return status;
}

float GPS::get_speed(){
    for(int i=0;i<5;i++){speed_str[i]=GPRMC[51+i];}
    speed_str[5]='\0';
    speed = (float)(speed_str[0]-0x30)*100.0+\
            (float)(speed_str[1]-0x30)*10.0+\
            (float)(speed_str[2]-0x30)*1.0+\
            (float)(speed_str[4]-0x30)*0.1;
    return speed;
}

int GPS::get_satelite_number(){
    number_of_satelite = (int)(GPGGA[45]-0x30)*10 + (int)(GPGGA[46]-0x30);
    return number_of_satelite;
}