#ifndef MBED_MYCAN_H
#define MBED_MYCAN_h

#include "mbed.h"

class myCAN: public CAN{

public:

    myCAN(PinName rd,PinName td);
    
    char* get_time(void);
    char* get_latitude(void);
    char* get_longitude(void);
    int get_NoS(void);
    
    float get_temp(void);
    int get_pres(void);
    
    int get_roll(void);
    int get_pitch(void);
    
    int get_mission_status(void);
    
    void make_logger_senddata(char* time,int NoS,char* latitude,char* longitude,int roll,int pitch,int temp,int pres);
    void make_mission_senddata(int status);
    
    void send(char user);

private:

    char CANdata[9][8];        
    CANMessage msg;
    
    char time[9]; //= {'0','0',':','0','0',':','0','0','\0'};
    int NoS;
    char latitude[10];
    char longitude[11];
    
    int mission_status;
    
    char hroll;
    char lroll;
    int roll;
    char hpitch;
    char lpitch;
    int pitch;
    int temp;
    int pres;
    
        
    void rxHandler(void);
};

#endif