#include "myCAN.h"
#include "IDDATA.h"

myCAN::myCAN(PinName rd,PinName td) : CAN(rd,td)
{
    frequency(CAN_BAUD);
    attach(this, &myCAN::rxHandler);
    
    time[0]='0';
    time[1]='0';
    time[2]=':';
    time[3]='0';
    time[4]='0';
    time[5]=':';
    time[6]='0';
    time[7]='0';
    time[8]='\0';
    
    latitude[0]='0';
    latitude[1]='0';
    latitude[2]='0';
    latitude[3]='0';
    latitude[4]=',';
    latitude[5]='0';
    latitude[6]='0';
    latitude[7]='0';
    latitude[8]='0';
    latitude[9]='\0';
    
    longitude[0]='0';
    longitude[1]='0';
    longitude[2]='0';
    longitude[3]='0';
    longitude[4]='0';
    longitude[5]=',';
    longitude[6]='0';
    longitude[7]='0';
    longitude[8]='0';
    longitude[9]='0';
    longitude[10]='\0';
}

void myCAN::send(char user)
{
    if(user == MISSION) {
        write(CANMessage(MISSION_STATUS,CANdata[MISSION_STATUS]));
        wait_ms(5);
    } else if(user == LOGGER) {
        write(CANMessage(GPS_TIME,CANdata[GPS_TIME]));
        wait_ms(5);
        write(CANMessage(GPS_LAT_1,CANdata[GPS_LAT_1]));
        wait_ms(5);
        write(CANMessage(GPS_LAT_2,CANdata[GPS_LAT_2]));
        wait_ms(5);
        write(CANMessage(GPS_LON_1,CANdata[GPS_LON_1]));
        wait_ms(5);
        write(CANMessage(GPS_LON_2,CANdata[GPS_LON_2]));
        wait_ms(5);
        write(CANMessage(SCP1000_PRES_TEMP,CANdata[SCP1000_PRES_TEMP]));
        wait_ms(5);
        write(CANMessage(ADXL345_XYZ,CANdata[ADXL345_XYZ]));
        wait_ms(5);
        write(CANMessage(ITG3200_XYZ,CANdata[ITG3200_XYZ]));
        wait_ms(5);
    } else {}
}

void myCAN::rxHandler(void)
{
    if(read(msg)){
        for(int i=0; i<8; i++) {
            CANdata[msg.id][i]=msg.data[i];
        }
    }
}

void myCAN::make_logger_senddata(char* time,int NoS,char* latitude,char* longitude,int roll,int pitch,int temp,int pres)
{
    for(int i=0; i<8; i++) {
        CANdata[GPS_TIME][i] = time[i];
    }
    CANdata[GPS_LAT_2][1] = NoS;

    for(int i=0; i<8; i++) {
        CANdata[GPS_LAT_1][i] = latitude[i];
    }
    for(int i=0; i<1; i++) {
        CANdata[GPS_LAT_2][i] = latitude[i+8];
    }

    for(int i=0; i<8; i++) {
        CANdata[GPS_LON_1][i] = longitude[i];
    }
    for(int i=0; i<2; i++) {
        CANdata[GPS_LON_2][i] = longitude[i+8];
    }

    //CANdata[SCP1000_PRES_TEMP][0]=(char)((temp & 0xF0)>>4);
    //CANdata[SCP1000_PRES_TEMP][1]=(char)(temp & 0x0F);
    //CANdata[SCP1000_PRES_TEMP][2]=(char)((pres & 0xF0)>>4);
    //CANdata[SCP1000_PRES_TEMP][3]=(char)(pres & 0x0F);
    
    CANdata[ADXL345_XYZ][0] = (char)((roll&0xFF00)>>8);
    CANdata[ADXL345_XYZ][1] = (char)(roll&0x00FF);
    
    CANdata[ADXL345_XYZ][2] = (char)((pitch&0xFF00)>>8);
    CANdata[ADXL345_XYZ][3] = (char)(pitch&0x00FF);
}

char* myCAN::get_time(void)
{
    for(int i=0; i<8; i++) {
        time[i] = CANdata[GPS_TIME][i];
    }
    return time;
}

char* myCAN::get_latitude(void)
{
    for(int i=0; i<8; i++) {
        latitude[i] = CANdata[GPS_LAT_1][i];
    }
    for(int i=0; i<1; i++) {
        latitude[i+8] = CANdata[GPS_LAT_2][i];
    }
    return latitude;
}

    char* myCAN::get_longitude(void)
{
    for(int i=0; i<8; i++) {
        longitude[i] = CANdata[GPS_LON_1][i];
    }
    for(int i=0; i<1; i++) {
        longitude[i+8] = CANdata[GPS_LON_2][i];
    }
    return longitude;
}

int myCAN::get_NoS(void)
{
    NoS = CANdata[GPS_LAT_2][1];
    return NoS;
}

int myCAN::get_roll(void){
    hroll = CANdata[ADXL345_XYZ][0];
    lroll = CANdata[ADXL345_XYZ][1];
    roll = ((((short)(hroll))<<8) & 0xFF00) | (((short)(lroll))&0x00FF);
    return roll;
}

int myCAN::get_pitch(void){
    hpitch = CANdata[ADXL345_XYZ][2];
    lpitch = CANdata[ADXL345_XYZ][3];
    pitch = ((((short)(hroll))<<8) & 0xFF00) | (((short)(lroll))&0x00FF);
    return pitch;
}

float myCAN::get_temp(void)
{
    temp = (float)(((int)(CANdata[SCP1000_PRES_TEMP][0])<<4+(int)(CANdata[SCP1000_PRES_TEMP][1]))/20.0);
    return temp;
}

int myCAN::get_pres(void)
{
    pres = (int)(CANdata[SCP1000_PRES_TEMP][2])<<4+(int)(CANdata[SCP1000_PRES_TEMP][3]);
    return pres;
}

void myCAN::make_mission_senddata(int status){
    CANdata[MISSION_STATUS][0] = status;
}
    
int myCAN::get_mission_status(void){
    mission_status = CANdata[MISSION_STATUS][0];
    return mission_status;
}