#include "myCAN.h"
#include "IDDATA.h"

myCAN::myCAN(PinName rd,PinName td) : CAN(rd,td)
{
    frequency(CAN_BAUD);
    attach(this, &myCAN::rxHandler);
    
    time[0]='0';
    time[1]='0';
    time[2]=':';
    time[3]='0';
    time[4]='0';
    time[5]=':';
    time[6]='0';
    time[7]='0';
    time[8]='\0';
    
    latitude[0]='0';
    latitude[1]='0';
    latitude[2]='0';
    latitude[3]='0';
    latitude[4]=',';
    latitude[5]='0';
    latitude[6]='0';
    latitude[7]='0';
    latitude[8]='0';
    latitude[9]='\0';
    
    longitude[0]='0';
    longitude[1]='0';
    longitude[2]='0';
    longitude[3]='0';
    longitude[4]='0';
    longitude[5]=',';
    longitude[6]='0';
    longitude[7]='0';
    longitude[8]='0';
    longitude[9]='0';
    longitude[10]='\0';
}

void myCAN::send(char user)
{
    if(user == MISSION) {
        write(CANMessage(MISSION_STATUS,CANdata[MISSION_STATUS]));
    } else if(user == LOGGER) {
        write(CANMessage(GPS_TIME,CANdata[GPS_TIME]));
        write(CANMessage(GPS_LAT_1,CANdata[GPS_LAT_1]));
        write(CANMessage(GPS_LAT_2,CANdata[GPS_LAT_2]));
        write(CANMessage(GPS_LON_1,CANdata[GPS_LON_1]));
        write(CANMessage(GPS_LON_2,CANdata[GPS_LON_2]));
        write(CANMessage(SCP1000_PRES_TEMP,CANdata[SCP1000_PRES_TEMP]));
        write(CANMessage(ADXL345_XYZ,CANdata[ADXL345_XYZ]));
        write(CANMessage(ITG3200_XYZ,CANdata[ITG3200_XYZ]));
    } else {}
}

void myCAN::rxHandler(void)
{
    if(read(msg)){
        for(int i=0; i<8; i++) {
            CANdata[msg.id][i]=msg.data[i];
        }
    }
}

void myCAN::make_logger_senddata(char* time,int NoS,char* latitude,char* longitude,int a_z,int temp,int pres)
{
    for(int i=0; i<8; i++) {
        CANdata[GPS_TIME][i] = time[i];
    }
    CANdata[GPS_LAT_2][1] = NoS;

    for(int i=0; i<8; i++) {
        CANdata[GPS_LAT_1][i] = latitude[i];
    }
    for(int i=0; i<1; i++) {
        CANdata[GPS_LAT_2][i] = latitude[i+8];
    }

    for(int i=0; i<8; i++) {
        CANdata[GPS_LON_1][i] = longitude[i];
    }
    for(int i=0; i<2; i++) {
        CANdata[GPS_LON_2][i] = longitude[i+8];
    }

    CANdata[SCP1000_PRES_TEMP][0]=(char)((temp & 0xF0)>>4);
    CANdata[SCP1000_PRES_TEMP][1]=(char)(temp & 0x0F);
    CANdata[SCP1000_PRES_TEMP][2]=(char)((pres & 0xF0)>>4);
    CANdata[SCP1000_PRES_TEMP][3]=(char)(pres & 0x0F);
    
    CANdata[GPS_LAT_2][2] = a_z;
}

char* myCAN::get_time(void)
{
    for(int i=0; i<8; i++) {
        time[i] = CANdata[GPS_TIME][i];
    }
    return time;
}

char* myCAN::get_latitude(void)
{
    for(int i=0; i<8; i++) {
        latitude[i] = CANdata[GPS_LAT_1][i];
    }
    for(int i=0; i<1; i++) {
        latitude[i+8] = CANdata[GPS_LAT_2][i];
    }
    return latitude;
}

    char* myCAN::get_longitude(void)
{
    for(int i=0; i<8; i++) {
        longitude[i] = CANdata[GPS_LON_1][i];
    }
    for(int i=0; i<1; i++) {
        longitude[i+8] = CANdata[GPS_LON_2][i];
    }
    return longitude;
}

int myCAN::get_NoS(void)
{
    NoS = CANdata[GPS_LAT_2][1];
    return NoS;
}
float myCAN::get_a_x(void)
{

    return acel[0];
}
float myCAN::get_a_y(void)
{

    return acel[1];
}

int myCAN::get_a_z(void)
{  
    acel[2] = CANdata[GPS_LAT_2][2];
    return acel[2];
}

int myCAN::get_j_x(void)
{

    return jail[0];
}

int myCAN::get_j_y(void)
{

    return jail[1];
}

int myCAN::get_j_z(void)
{

    return jail[2];
}

float myCAN::get_temp(void)
{
    temp = (float)(((int)(CANdata[SCP1000_PRES_TEMP][0])<<4+(int)(CANdata[SCP1000_PRES_TEMP][1]))/20.0);
    return temp;
}

int myCAN::get_pres(void)
{
    pres = (int)(CANdata[SCP1000_PRES_TEMP][2])<<4+(int)(CANdata[SCP1000_PRES_TEMP][3]);
    return pres;
}