#ifndef MBED_MYCAN_H
#define MBED_MYCAN_h

#include "mbed.h"

class myCAN: public CAN{

public:

    myCAN(PinName rd,PinName td);
    
    char* get_time(void);
    char* get_latitude(void);
    char* get_longitude(void);
    int get_NoS(void);
    
    float get_temp(void);
    int get_pres(void);
    
    float get_a_x(void);
    float get_a_y(void);
    int get_a_z(void);
    int get_j_x(void);
    int get_j_y(void);
    int get_j_z(void);
    
    void make_logger_senddata(char* time,int NoS,char* latitude,char* longitude,int a_z,int temp,int pres);
    void make_mission_senddata(void);
    
    void send(char user);

private:

    char CANdata[9][8];        
    CANMessage msg;
    
    char time[9]; //= {'0','0',':','0','0',':','0','0','\0'};
    int NoS;
    char latitude[10];
    char longitude[11];
    
    int acel[3];
    int jail[3];
    
    int temp;
    int pres;
    
        
    void rxHandler(void);
};

#endif