#ifndef _SCP1000_H
#define _SCP1000_H

#include "mbed.h"

class SCP1000 {
    public:
        SCP1000(PinName mosi, PinName miso, PinName sclk, PinName cs);
        
        ~SCP1000() { /* empty */ };
        
        unsigned long readPressure();
        float readTemperature();
        void init_scp1000();      
        
    private:
        static const char PRESSURE = 0x1F;   //Pressure 3 MSB
        static const char PRESSURE_LSB = 0x20; //Pressure 16 LSB
        static const char TEMP = 0x21;       //16 bit temp
        SPI m_spi;
        DigitalOut m_cs;
        
        char read_register(char register_name);
        void write_register(char register_name, char register_value);
        float read_register16(char register_name);

};

#endif // _SCP1000_H