#define RIGHT 1
#define LEFT 0

#define VERTICAL 1
#define HORIZONTAL 0

#ifndef MBED_RS405CB_H
#define MBED_RS405CB_h

class RS405cb: public Serial{

public:

    RS405cb(PinName tx,PinName rx,PinName permit);
        
    //////////////RS405_SERVO_command/////////////////////////////////////////////
        /////function for setting
            void TORQUE_ON(unsigned char id);
            void ID_CHANGE(unsigned char oldid,unsigned char newid);
            void DECIDE_LIMIT_ANGLE(unsigned char id,unsigned int CWlimit,unsigned int CCWlimit);
            void REQUIRE_RETURN_PACKET(unsigned char id);
        /////function for control
            void Rotate_Servo(unsigned char id,char RL,unsigned int ANGLE);//ANGLE:0-900 means 0.0 degree to 90.0 degree
            void Rotate_Servo_Float(unsigned char id,float ANGLE);//ANGLE:-90.0 to -90.0
            void Rotate_Servo_Float_Test(unsigned char id);//Ones this function called,main sequence is put in "while(1)"
    
    //function for 2013 meister's airframe "SHO"  
        void Sho_Init(int center_vert,int center_hori,int pls15_vert,int pls15_hori,int mns15_vert,int mns15_hori);
        void Sho_Rotate_Servo(unsigned char id,int VH,float angle_of_attack);//-15.0 deg to 15.0 deg


private:

    //////function for RS405 basic command
        void RSW2(unsigned char id,unsigned char flg,unsigned char adr,unsigned char len,unsigned char cnt,unsigned char lowdata,unsigned char highdata);
        void RSW1(unsigned char id,unsigned char flg1,unsigned char adr1,unsigned char len1,unsigned char cnt1,unsigned char data1);
        void RSW0(unsigned char id,unsigned char flg,unsigned char adr,unsigned char len,unsigned char cnt);

    //variable for 2013 meister's airframe "SHO"  
        int center_v,center_h,pls15_v,pls15_h,mns15_v,mns15_h;
    
    //Serial rs405cb;
        DigitalOut _permit;
        
};

#endif