#ifndef IMU_I2C_H
#define IMU_I2C_H

#include "mbed.h"

/////////////ADXL345///////////////////////////////////////////////
//Registers.
#define ADXL345_DEVID_REG          0x00
#define ADXL345_THRESH_TAP_REG     0x1D
#define ADXL345_OFSX_REG           0x1E
#define ADXL345_OFSY_REG           0x1F
#define ADXL345_OFSZ_REG           0x20
#define ADXL345_DUR_REG            0x21
#define ADXL345_LATENT_REG         0x22
#define ADXL345_WINDOW_REG         0x23
#define ADXL345_THRESH_ACT_REG     0x24
#define ADXL345_THRESH_INACT_REG   0x25
#define ADXL345_TIME_INACT_REG     0x26
#define ADXL345_ACT_INACT_CTL_REG  0x27
#define ADXL345_THRESH_FF_REG      0x28
#define ADXL345_TIME_FF_REG        0x29
#define ADXL345_TAP_AXES_REG       0x2A
#define ADXL345_ACT_TAP_STATUS_REG 0x2B
#define ADXL345_BW_RATE_REG        0x2C
#define ADXL345_POWER_CTL_REG      0x2D
#define ADXL345_INT_ENABLE_REG     0x2E
#define ADXL345_INT_MAP_REG        0x2F
#define ADXL345_INT_SOURCE_REG     0x30
#define ADXL345_DATA_FORMAT_REG    0x31
#define ADXL345_DATAX0_REG         0x32
#define ADXL345_DATAX1_REG         0x33
#define ADXL345_DATAY0_REG         0x34
#define ADXL345_DATAY1_REG         0x35
#define ADXL345_DATAZ0_REG         0x36
#define ADXL345_DATAZ1_REG         0x37
#define ADXL345_FIFO_CTL           0x38
#define ADXL345_FIFO_STATUS        0x39

//Data rate codes.
#define ADXL345_3200HZ      0x0F
#define ADXL345_1600HZ      0x0E
#define ADXL345_800HZ       0x0D
#define ADXL345_400HZ       0x0C
#define ADXL345_200HZ       0x0B
#define ADXL345_100HZ       0x0A
#define ADXL345_50HZ        0x09
#define ADXL345_25HZ        0x08
#define ADXL345_12HZ5       0x07
#define ADXL345_6HZ25       0x06

// read or write bytes
#define ADXL345_I2C_READ    0xA7  
#define ADXL345_I2C_WRITE   0xA6 
#define ADXL345_I2C_ADDRESS 0x53   //the ADXL345 7-bit address is 0x53 when ALT ADDRESS is low as it is on the sparkfun chip: when ALT ADDRESS is high the address is 0x1D

/////////////when ALT ADDRESS pin is high:
//#define ADXL345_I2C_READ    0x3B   
//#define ADXL345_I2C_WRITE   0x3A
//#define ADXL345_I2C_ADDRESS 0x1D 

#define ADXL345_X           0x00
#define ADXL345_Y           0x01
#define ADXL345_Z           0x02

// modes
#define MeasurementMode     0x08

////////////////L3G4200D/////////////////////////////////////////////////////////////////
// register addresses
#define L3G4200D_WHO_AM_I      0x0F

#define L3G4200D_CTRL_REG1     0x20
#define L3G4200D_CTRL_REG2     0x21
#define L3G4200D_CTRL_REG3     0x22
#define L3G4200D_CTRL_REG4     0x23
#define L3G4200D_CTRL_REG5     0x24
#define L3G4200D_REFERENCE     0x25
#define L3G4200D_OUT_TEMP      0x26
#define L3G4200D_STATUS_REG    0x27

#define L3G4200D_OUT_X_L       0x28
#define L3G4200D_OUT_X_H       0x29
#define L3G4200D_OUT_Y_L       0x2A
#define L3G4200D_OUT_Y_H       0x2B
#define L3G4200D_OUT_Z_L       0x2C
#define L3G4200D_OUT_Z_H       0x2D

#define L3G4200D_FIFO_CTRL_REG 0x2E
#define L3G4200D_FIFO_SRC_REG  0x2F

#define L3G4200D_INT1_CFG      0x30
#define L3G4200D_INT1_SRC      0x31
#define L3G4200D_INT1_THS_XH   0x32
#define L3G4200D_INT1_THS_XL   0x33
#define L3G4200D_INT1_THS_YH   0x34
#define L3G4200D_INT1_THS_YL   0x35
#define L3G4200D_INT1_THS_ZH   0x36
#define L3G4200D_INT1_THS_ZL   0x37
#define L3G4200D_INT1_DURATION 0x38

///////////////ITG3200/////////////////////////////////////////////////////
#define ITG3200_I2C_ADDRESS 0x68 //7-bit address.

#define WHO_AM_I_REG    0x00
#define SMPLRT_DIV_REG  0x15
#define DLPF_FS_REG     0x16
#define INT_CFG_REG     0x17
#define INT_STATUS      0x1A
#define TEMP_OUT_H_REG  0x1B
#define TEMP_OUT_L_REG  0x1C
#define GYRO_XOUT_H_REG 0x1D
#define GYRO_XOUT_L_REG 0x1E
#define GYRO_YOUT_H_REG 0x1F
#define GYRO_YOUT_L_REG 0x20
#define GYRO_ZOUT_H_REG 0x21
#define GYRO_ZOUT_L_REG 0x22
#define PWR_MGM_REG     0x3E

//----------------------------
// Low Pass Filter Bandwidths
//----------------------------
#define LPFBW_256HZ 0x00
#define LPFBW_188HZ 0x01
#define LPFBW_98HZ  0x02
#define LPFBW_42HZ  0x03
#define LPFBW_20HZ  0x04
#define LPFBW_10HZ  0x05
#define LPFBW_5HZ   0x06

typedef char byte;

///////////////class///////////////////////////////////////////////////////

class IMU_I2C {

public:

    /**
     * Constructor.
     */
    IMU_I2C(PinName sda, PinName scl);

//////ADXL345_function///////////////////////////////////////////////////
    void getOutput(int* readings);
    char getDeviceID(void);
    int setPowerMode(char mode);
    int setPowerControl(char settings);     
    char getPowerControl(void);
    char getDataFormatControl(void);
    int setDataFormatControl(char settings);
    int setDataRate(char rate);
    char getOffset(char axis);
    int setOffset(char axis, char offset);
    char getFifoControl(void);
    int setFifoControl(char settings);
    char getFifoStatus(void);
    char getTapThreshold(void);
    int setTapThreshold(char threshold);
    float getTapDuration(void);
    int setTapDuration(short int duration_us);
    float getTapLatency(void);
    int setTapLatency(short int latency_ms);
    float getWindowTime(void);
    int setWindowTime(short int window_ms);
    char getActivityThreshold(void);
    int setActivityThreshold(char threshold);
    char getInactivityThreshold(void);
    int setInactivityThreshold(char threshold);
    char getTimeInactivity(void);
    int setTimeInactivity(char timeInactivity);
    char getActivityInactivityControl(void);
    int setActivityInactivityControl(char settings);
    char getFreefallThreshold(void);
    int setFreefallThreshold(char threshold);
    char getFreefallTime(void);
    int setFreefallTime(short int freefallTime_ms);
    char getTapAxisControl(void);
    int setTapAxisControl(char settings);
    char getTapSource(void);
    char getInterruptEnableControl(void);
    int setInterruptEnableControl(char settings);
    char getInterruptMappingControl(void);
    int setInterruptMappingControl(char settings);
    char getInterruptSource(void);
    
///////////////L3G4200D_function///////////////////////////////////////////////
    void read(int g[3]);
    
///////////////ITG3200_function////////////////////////////////////////////////
    char getWhoAmI(void);
    void setWhoAmI(char address);
    char getSampleRateDivider(void);
    void setSampleRateDivider(char divider);
    int getInternalSampleRate(void);
    void setLpBandwidth(char bandwidth);
    char getInterruptConfiguration(void);
    void setInterruptConfiguration(char config);
    bool isPllReady(void);
    bool isRawDataReady(void);
    float getTemperature(void);
    int getGyroX(void);
    int getGyroY(void);
    int getGyroZ(void);
    char getPowerManagement(void);
    void setPowerManagement(char config);
   
private:

    I2C i2c_;
 
////////////ADXL345////////////////////////////////////////////////////////////
    char SingleByteRead(char address);
    int SingleByteWrite(char address, char data);
    void multiByteRead(char startAddress, char* ptr_output, int size);
    int multiByteWrite(char startAddress, char* ptr_data, int size);

////////////L3G4200D///////////////////////////////////////////////////////////
    byte data[6];
    int _rates[3];
    void writeReg(byte reg, byte value);
    byte readReg(byte reg);
    void enableDefault(void);
    
};

#endif 
