//247-426-Nucleo_Lab_8 xxx
//This software is derived from Nucleo_sg90_remote_control.
//It outputs a PWM signal that is compatible with Tower Pro SG90 servos.
//It makes the servo move according to the temperature read from a DS1820
//temperature sensor.
//Pressing the user button makes the software define the temperature it then
//reads as a reference temperature that is associated to the middle position
//that can be taken by the sg90 servo. An increase in temperature relative to
//this reference temperature will then make the servo rotate in one direction
//whereas a decrease with respect to the reference will rather make it rotate in
//the other direction.
//

//Just connect the brown wire of a SG90 servo to GND, its red wire to AVDD and
//its the orange wire to D11 to have the SMT32-F401RE control the servo.
//
//
//material:
//      DS18S20: temperature sensor
//
//signals:
//      D11= pwm signal to use to control SG90 directly
//      D8=  used to communicate with the 1-wire temperature sensor Ds18s20
//
//  Circuit:
//                                                             _____
//                                                             |   | DS18S20
//                                                             -----(front view)
//                                                             | | |
//                                                       GND___| | |+5V
//      Orange wire of servo SG90 --D11                          |
//      Red wire of servo SG90 -----+5V                 D8_______|-/\/\/\--+5v
//      Brown wire of servo SG90 ---GND                              10k
//
// Hyperterminal configuration
// 9600 bauds, 8-bit data, no parity



#include "DS1820.h"
#include "mbed.h"
#define NUMBER_OF_POSITIONS sizeof(pulseDurationInMicroSeconds)/sizeof(int)
#define PWM_PERIOD_FOR_SG90_IN_MS           20
#define PWM_PERIOD_FOR_MODULATION_IN_US     25  


Serial pc(SERIAL_TX, SERIAL_RX);
DS1820 probe(D8);

PwmOut led(LED1);
DigitalOut userLED(LED1);

PwmOut towerProSG90(D11);
InterruptIn userButton(USER_BUTTON);
int index;
int pulseDurationInMicroSeconds[]=
        {1500,1625,1750,1875,2000, 1875,1750,1625,1500,1375,1250,1125,1000,1125,1250,1375};    
void responseToUserButtonPressed(void)
{
    index++;
    if (index >= NUMBER_OF_POSITIONS)
    {
        index = 0;
    }
    towerProSG90.pulsewidth_us(pulseDurationInMicroSeconds[index]);    
}

int main()
{
    index = 0;    
    towerProSG90.period_ms(PWM_PERIOD_FOR_SG90_IN_MS);
    towerProSG90.pulsewidth_us(pulseDurationInMicroSeconds[index]);
    userButton.fall(&responseToUserButtonPressed);
    
    userLED = 1;
    while(1)
    {
        userLED = !userLED;
        
        probe.convertTemperature(true, DS1820::all_devices);         //Start temperature conversion, wait until ready        
        printf("Il fait: %3.1foC\r\n", probe.temperature());   
        wait(1.25);   
    }
}
