#include "mbed.h"
//options de compilation
//#define TEST


#define TFT_SPDF5408

//intégration
// représentation
// G: gauche, D: droit, H: haut, B: bas
// E: écran, T: touch
// Ecran:
//  (XE_G,YE_H)  ___  (XE_D,YE_H)
//              |   |
//              |   |
//  (XE_G,YE_B) |___| (XE_G,YE_B)
//
// représentation du touch
//  (XT_G,YT_H)  ___  (XT_D,YT_H)
//              |   |
//              |   |
//  (XT_G,YT_B) |___| (XT_G,YT_B)

// équations pour conversion
// XT: x touch lu, YT: y touch lu, XE: x ecran, YE: y ecran
// XE = (XE_D - XE_G)/(XT_D - XT_G)*(XT - XT_G) + XE_G
// YE = (YE_H - YE_B)/(YT_H - YT_B)*(YT - YT_G) + YE_G

// l'application présente 3 boutons et une surface de dessin
// bouton noir: effacer
// bouton rouge: dessiner en rouge
// bouton blanc: dessiner en blanc

//touchscreen
#define IDLE    1
#define ACTIVE  0
#define COMMAND 0
#define DATA    1

#ifdef TFT_SPDF5408
#define YP A3
#define XM A2 
#define YM D9  
#define XP D8 
#endif

#ifdef MON_TFT
#define YP A1  // must be an analog pin, use "An" notation!
#define YM D7   // can be a digital pin
#define XP D6   // can be a digital pin
#define XM A2  // must be an analog pin, use "An" notation!
#endif

#define TOUCH_SEUIL_HAUT    3000
#define TOUCH_SEUIL_BAS     16


//tftspfd5408
#define TFTWIDTH  240
#define TFTHEIGHT 320

#define LCD_CS A3
#define LCD_CD A2
#define LCD_WR A1
#define LCD_RD A0
#define LCD_RESET A4

#define TFT_NORTH SPFD5408_MADCTL_MY | SPFD5408_MADCTL_BGR

#if 0
#define TFT_EAST  {SPFD5408_MADCTL_MX | SPFD5408_MADCTL_MY | SPFD5408_MADCTL_MV | SPFD5408_MADCTL_BGR}
#define TFT_SOUTH {SPFD5408_MADCTL_MX | SPFD5408_MADCTL_BGR}
#define TFT_WEST  {SPFD5408_MADCTL_MV | SPFD5408_MADCTL_BGR}
#endif

#define BLACK   0x0000
#define BLUE    0x001F
#define RED     0xF800
#define GREEN   0x07E0
#define CYAN    0x07FF
#define MAGENTA 0xF81F
#define YELLOW  0xFFE0
#define WHITE   0xFFFF

#define SPFD5408_SOFTRESET          0x01
#define SPFD5408_SLEEPOUT           0x11

#if 0
#define SPFD5408_SLEEPIN            0x10
#define SPFD5408_NORMALDISP         0x13
#define SPFD5408_INVERTOFF          0x20
#define SPFD5408_INVERTON           0x21
#define SPFD5408_GAMMASET           0x26
#define SPFD5408_DISPLAYOFF         0x28
#endif

#define SPFD5408_DISPLAYON          0x29
#define SPFD5408_COLADDRSET         0x2A
#define SPFD5408_PAGEADDRSET        0x2B
#define SPFD5408_MEMORYWRITE        0x2C
#define SPFD5408_PIXELFORMAT        0x3A
#define SPFD5408_FRAMECONTROL       0xB1
#if 0
#define SPFD5408_DISPLAYFUNC        0xB6
#define SPFD5408_ENTRYMODE          0xB7
#define SPFD5408_POWERCONTROL1      0xC0
#define SPFD5408_POWERCONTROL2      0xC1
#define SPFD5408_VCOMCONTROL1       0xC5
#define SPFD5408_VCOMCONTROL2       0xC7

#define SPFD5408_MADCTL             0x36
#define SPFD5408_MADCTL_MX          0x40
#define SPFD5408_MADCTL_MV          0x20
#define SPFD5408_MADCTL_ML          0x10
#define SPFD5408_MADCTL_RGB         0x00
#endif
#define SPFD5408_MEMCONTROL         0x36
#define SPFD5408_MADCTL_MY          0x80
#define SPFD5408_MADCTL_BGR         0x08
#if 0
#define SPFD5408_MADCTL_MH          0x04
#endif

#define IDLE    1
#define ACTIVE  0
#define COMMAND 0
#define DATA    1

#define TEMPS   40


//integration

#define XE_G    0
#define XE_D    240
#define YE_H    0
#define YE_B    320
#define XT_G    3700
#define XT_D    600
#define YT_H    600
#define YT_B    3700

//definitions de variables
//touchscreen
uint16_t x;
uint16_t y;
uint16_t z;

//tftspfd5408
DigitalOut pinRD(LCD_RD);       //PA_0;
DigitalOut pinWR(LCD_WR);       //PA_1;
DigitalOut pinCD(LCD_CD);       //PA_4;
DigitalOut pinCS(LCD_CS);       //PB_0;
DigitalOut pinReset(LCD_RESET); //PC_1;

//integration
Serial pc(SERIAL_TX, SERIAL_RX, 9600);
DigitalOut myled(LED1);
uint16_t couleurVariable;
uint16_t tableDeCouleur[]=
    {
       WHITE, YELLOW, GREEN, BLUE, CYAN, MAGENTA, RED
    };   


//declarations de fonctions
//touchscreen 
void restoreXY(void);
uint16_t readTouchX(void);
uint16_t readTouchY(void);
uint16_t detectTouch(void);

//tftspfd5408
void WriteCommand(uint8_t c);
void WriteData(uint8_t d);
void begin(void);
void setAddrWindow(int x1, int y1, int x2, int y2);
void fillRect(uint16_t x1, uint16_t y1, uint16_t w, uint16_t h, uint16_t fillcolor);

//definitions de fonctions
//touchscreen
void restoreXY(void)
{
DigitalOut pinXP(XP);
DigitalOut pinXM(XM);    
DigitalOut pinYP(YP);
DigitalOut pinYM(YM);

    pinXP = 1;
    pinXM = 1;
    pinYP = 1;
    pinYM = 1;
    wait_ms(1);
}

uint16_t readTouchX(void)
{
uint16_t value;
DigitalOut pinXP(XP); 
DigitalOut pinXM(XM);
AnalogIn pinYP(YP);
DigitalIn pinYM(YM);

    pinXP = 0;
    pinXM = 1;
    pinYM.mode(OpenDrain);
    value = pinYP.read_u16() >> 4;
    restoreXY();
    return value;
}

uint16_t readTouchY(void)
{
uint16_t value;
DigitalIn pinXP(XP); 
AnalogIn pinXM(XM);
DigitalOut pinYP(YP);
DigitalOut pinYM(YM);

    pinYP = 1;
    pinYM = 0;
    pinXP.mode(OpenDrain);
    value = pinXM.read_u16() >> 4;
    restoreXY();    
    return value;
}

uint16_t detectTouch(void)
{
uint16_t firstValue;
uint16_t secondValue;
DigitalOut pinXP(XP); 
DigitalOut pinXM(XM);
AnalogIn pinYP(YP);
DigitalIn pinYM(YM);
    
    pinYM.mode(OpenDrain);
    pinXP = 1;
    pinXM = 0;
    firstValue = pinYP.read_u16() >> 4;

    pinXP = 0;
    pinXM = 1;
    secondValue = pinYP.read_u16() >> 4;

    restoreXY();
    
    if (secondValue > firstValue)
    {
        return firstValue;
    }
    return secondValue;
}

//tftspfd5408
void WriteCommand(uint8_t c)
{
BusInOut portTFT(D8, D9, D2, D3, D4, D5, D6, D7);
    portTFT.output();    
    pinCD = COMMAND;
    pinWR = ACTIVE;
    portTFT = c;
    pinWR = IDLE;
}

void WriteData(uint8_t d)
{
BusInOut portTFT(D8, D9, D2, D3, D4, D5, D6, D7);
    portTFT.output();    
    pinCD = DATA;
    pinWR = ACTIVE;
    portTFT = d;
    pinWR = IDLE;
}

void begin(void)
{
    pinCS = IDLE; 
    pinCD = DATA;
    pinWR = IDLE;
    pinRD = IDLE;

    pinReset = ACTIVE;
    wait_ms(100);
    pinReset = IDLE;
    wait_ms(100);
    pinCS = ACTIVE;
    
    WriteCommand(SPFD5408_SOFTRESET);
    WriteData(0);
    wait_ms(50);
    
    WriteCommand(SPFD5408_MEMCONTROL);
    WriteData(TFT_NORTH); //(SPFD5408_MADCTL_MY | SPFD5408_MADCTL_BGR);
    
    WriteCommand(SPFD5408_PIXELFORMAT);
    WriteData(0x55);
  
    WriteCommand(SPFD5408_FRAMECONTROL);
    WriteData(0x00);
    WriteData(0x1B);
  
    WriteCommand(SPFD5408_SLEEPOUT);
    WriteData(0);
  
    WriteCommand(SPFD5408_DISPLAYON);
    WriteData(0);
}

void setAddrWindow(int x1, int y1, int x2, int y2) {
    pinCS = ACTIVE;
    wait_us(TEMPS);
    WriteCommand(SPFD5408_COLADDRSET);
    WriteData(x1 >> 8);
    WriteData(x1);
    WriteData(x2 >> 8);
    WriteData(x2);
    wait_us(TEMPS);
    pinCS = IDLE;

    pinCS = ACTIVE;
    wait_us(TEMPS);
    WriteCommand(SPFD5408_PAGEADDRSET);
    WriteData(y1 >> 8);
    WriteData(y1);
    WriteData(y2 >> 8);
    WriteData(y2);
    pinCS = IDLE;
}

void fillRect(uint16_t x1, uint16_t y1, uint16_t w, uint16_t h, uint16_t fillcolor)
{
    BusInOut portTFT(D8, D9, D2, D3, D4, D5, D6, D7);
    uint8_t hi, lo;
    uint16_t  x2, y2;
    uint16_t i, j;

    portTFT.output();    

    x2 = x1 + w - 1;
    y2 = y1 + h - 1;
    setAddrWindow(x1, y1, x2, y2);

    hi = fillcolor >> 8;
    lo = fillcolor;

    pinCS = ACTIVE;

    WriteCommand(SPFD5408_MEMORYWRITE);
    pinCD = DATA;
    for (i = h; i > 0; i--)
    {
        for (j = w; j > 0; j--)

        {
            pinWR = ACTIVE;
            portTFT = hi;
            pinWR = IDLE; 
            pinWR = ACTIVE;
            portTFT = lo;
            pinWR = IDLE;             
        }
    }
    pinCS = IDLE;
}
 
//intégration

int32_t conversion(int32_t x, int32_t x0, int32_t y0, int32_t x1, int32_t y1)
{
    int32_t retour;
    int32_t limiteInferieure;
    int32_t limiteSuperieure;
    if (y0 < y1)
    {
        limiteInferieure = y0;
        limiteSuperieure = y1;
    }
    else
    {
        limiteInferieure = y1;
        limiteSuperieure = y0;
    }
    retour = (x - x0) * (y1 -y0) / (x1 -x0) + y0;
  
    if (retour < limiteInferieure)
    {
        return limiteInferieure;
    }        
    if (retour > limiteSuperieure)
    {
        return limiteSuperieure;
    }
    return retour;
};

uint16_t determineLaCouleur(void)
{
        return tableDeCouleur[3];
}

int main()
{ 
uint16_t couleur;
//initialisation du touchscreen
    restoreXY();
   
//initialisation du tftspfd5408
    begin();

//intégration
    couleur = RED;
    couleurVariable = BLUE;
    fillRect(0, 0, 240, 280, BLACK); //surface de dessin  
//bouton noir
    fillRect(0, 280, 80, 2, WHITE); // ligne horizontale haut
    fillRect(0, 282, 2, 38, WHITE); // ligne verticale gauche
    fillRect(79, 282, 1, 38, WHITE); // ligne verticale droite
    fillRect(2, 318, 77, 2, WHITE); //ligne horizontale bas
    fillRect(2, 282, 77, 36, BLACK); // centre noir
//bouton rouge
    fillRect(80, 280, 80, 40, WHITE); // moins d'instructions mais plus long
    fillRect(81, 282, 78, 36, RED); // bouton rouge
//bouton cyan
    fillRect(160, 280, 80, 40, WHITE); // moins d'instructions mais plus long
    fillRect(161, 282, 77, 36, BLUE); //bouton bleu
//indicateur
    fillRect(81, 282, 10, 10, GREEN); //couleur rouge par défaut

    while(1) {

//tâches du touchscreen
        myled = !myled;

        x = readTouchX();
        y = readTouchY();
        z = detectTouch();
//tâches du tftspfd5408


//tâches d'intégration
        couleurVariable = determineLaCouleur();
        fillRect(228, 282, 10, 10, couleurVariable); //indicateur de couleur

        if ((z > TOUCH_SEUIL_BAS)&&(z < TOUCH_SEUIL_HAUT))
        {
#ifdef TEST
            pc.printf("x lu %u\t ", x);
            pc.printf("y lu %u\t ", y);
            pc.printf("z lu %u\t ", z);
#endif
            float u = conversion((float)x, XT_G, XE_G, XT_D, XE_D);
            float v = conversion((float)y, YT_B, YE_B, YT_H, YE_H);

#ifdef TEST
            pc.printf("x ecran %f\t ", u);
            pc.printf("y ecran %f\r\n", v);
#endif
            if (v < 280)
            {
                fillRect(u, v, 1, 1, couleur);    
            }
            else
            {
                if (u < 80)
                {
                    fillRect(0, 0, 240, 280, BLACK);
                }
                else
                {
                    if (u < 160)
                    {
                        //indicateur RED
                        fillRect(81, 282, 10, 10, GREEN); //couleur rouge par défaut
                        fillRect(161,282, 10, 10, couleurVariable);

                        couleur = RED;
                        pc.printf("couleur: rouge\n\r");
                    }
                    else
                    {
                        //indicateur AUTRE
                        fillRect(161, 282, 77, 36, couleurVariable);
                        fillRect(161, 282, 10, 10, GREEN); //bouton bleu pale
                        fillRect(81, 282, 10, 10, RED);
                        couleur = couleurVariable;
                        pc.printf("couleur variable\n\r");
                    }
                }
            }
        }
    }
}
