//247-426-Nucleo_Lab_7
//This software is derived from Nucleo_pwm_servo_sg90.
//It outputs a PWM signal that is compatible with Tower Pro SG90 servos.
//It makes the servo move from one programmed position to another each time the
//user button is pressed.
//The programmed positions are defined by the values that are stored in
//the variable "pulseDurationInMicroSeconds". 
//An index counter is used to select which value is to be used to set the pulse
//duration of the PWM signal that controls that servo.
//The value of this index counter is changed each time the user button is
//pressed and the changes are made in a way that makes the program repeatedly
//cycles through all the possible positions.
//It is just necessary to add values to "pulseDurationInMicroSeconds" to have
//the servo adopt more positions.

//Just connect the brown wire of a SG90 servo to GND, its red wire to AVDD and
//its the orange wire to D11 to have the SMT32-F401RE control the servo.
//

//Remote control of a SG90 servo is also possible if the Nucleo board is allowed
//to control an infrared LED as an infrared receptor is connected to the servo.
//
//material:
//      Infrared LED = LTE-5802A, Receiver = RPM7140-V4R
//
//signals:
//      D11= pwm signal to use to control SG90 directly
//      D10= !D11 = signal to use to control the transmitter's LED
//      D9 = 40kHz signal to use to modulate the LED output
//
//
//Transmitter: (powered by Nucleo's supply)
//   +5 ---/\/\/\----------- |
//           180             |
//                           |_
//                           \/  LTE-5802A
//                           --
//                     ______|______
//                   |/             \|
//  D10---/\/\/\-----|               |-----/\/\/\----- D9
//  (!pwm)   10k      |\ <-emitter-> /|       10k      (40kHz)
//                    |             |
//                   GND           GND
//
//  GND of Nucleo board ------ GND
//
//Receiver: (powered by remote supply)
//
//                                                             _____
//                                                             | O | RPM7140-V4R
//                                      +5---/\/\/\----        ----- (front view)
//                                            10k     |        | | |
//                                                    |        | | |______+5v
//      Orange wire of servo SG90 --------------------.--      | |________GND 
//      Red wire of servo SG90 -----+5V                  \|    | 
//      Brown wire of servo SG90 ---GND                   |-----
//                                              emitter  /|
//                                                       |
//                                                      GND

#include "mbed.h"
#define NUMBER_OF_POSITIONS sizeof(pulseDurationInMicroSeconds)/sizeof(int)
#define PWM_PERIOD_FOR_SG90_IN_MS           20
#define PWM_PERIOD_FOR_MODULATION_IN_US     25  
DigitalOut userLED(LED1);
PwmOut towerProSG90(D11);
PwmOut remoteControlOutput(D10);
PwmOut modulatingOutput(D9);
InterruptIn userButton(USER_BUTTON);
int index;
int pulseDurationInMicroSeconds[]=
        {1500,1625,1750,1875,2000, 1875,1750,1625,1500,1375,1250,1125,1000,1125,1250,1375};    
void responseToUserButtonPressed(void)
{
    index++;
    if (index >= NUMBER_OF_POSITIONS)
    {
        index = 0;
    }
    towerProSG90.pulsewidth_us(pulseDurationInMicroSeconds[index]);    
    remoteControlOutput.pulsewidth_us(PWM_PERIOD_FOR_SG90_IN_MS*1000 - pulseDurationInMicroSeconds[index]);
}

int main()
{
    index = 0;    
    towerProSG90.period_ms(PWM_PERIOD_FOR_SG90_IN_MS);
    towerProSG90.pulsewidth_us(pulseDurationInMicroSeconds[index]);
    remoteControlOutput.period_ms(PWM_PERIOD_FOR_SG90_IN_MS);
    remoteControlOutput.pulsewidth_us(PWM_PERIOD_FOR_SG90_IN_MS*1000 - pulseDurationInMicroSeconds[index]);
    modulatingOutput.period_us(PWM_PERIOD_FOR_MODULATION_IN_US);
    modulatingOutput.pulsewidth_us(PWM_PERIOD_FOR_MODULATION_IN_US/2);
    userButton.fall(&responseToUserButtonPressed);
      
    while(1)
    {
        userLED = !userLED;
        wait(1);
    }
}
