//-------------------------------------------------------------------
//QEIライブラリ使用
//-------------------------------------------------------------------

//mbed用ライブラリ
#include "mbed.h"
//エンコーダ用ライブラリ
#include "QEI.h"

//変数宣言
//1回転でのパルス数
#define ROTATE_PER_REVOLUTIONS  360

//エンコーダのチャンネルAとBの初期状態を決める
QEI wheel(P1_0, P1_1, NC, ROTATE_PER_REVOLUTIONS, QEI::X4_ENCODING);

//メイン関数
int main()
{
    //作業用変数
    long delt_ms = 1;
    wait_ms(delt_ms);

    while(1) {
        
        //エンコーダ値格納用変数
        static double y;
        static double x;
        
        //エンコーダの値(生)の取得
        y=(double)wheel.getPulses();
        
        //エンコーダの値を角度に変換
        x=y*360/(ROTATE_PER_REVOLUTIONS);
        
        //エンコーダ値(角度)の表示(TeraTerm)
        printf("%f\r\n",x);
        
        //待機時間(1ミリ秒)
        wait_ms(delt_ms);

    }

}