//mbed用ライブラリ
#include "mbed.h"

//プロトタイプ宣言
void putPWM(float);

//作業用変数
PwmOut Servo1(D3);          //Pwm出力Servo1の初期化
PwmOut Servo2(D4);          //Pwm出力Servo2の初期化

//メイン関数
int main()
{
    Servo1.period(0.020);   //PWM波の周期の設定
    Servo2.period(0.020);
    
    //作業用変数
    long delt_ms = 1;
    
    //---------------------------------------------------------
    /*デューティー比を変更する場合は以下の数値を変える(-100%≦DUTY≦100%)*/
    float DUTY=50;
    
    //---------------------------------------------------------
    
    float PWM=DUTY/100;
    wait_ms(delt_ms);

    while(1) {

        putPWM(PWM);
        wait_ms(delt_ms);

    }

}

/*モータの回転方向と速度を与える putPWM関数*/
void putPWM(float u)
{
    
    //回転方向と速度の条件分け
    if(u > 0) {
        //CCW(動かして確認)
        Servo1.write(u);
        Servo2.write(0);
    } else if(u < 0) {
        //CW(動かして確認)
        u=abs(u);
        Servo1.write(0);
        Servo2.write(u);
    } else {
        Servo1.write(0);
        Servo2.write(0);
    }

}