#include "mbed.h"
#include "rtos.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);


//スレッド（LED2用）
void led2_thread(void const *args)
{
    while (true) {
        led2 = !led2;
        Thread::wait(800);
    }
}

//スレッド（LED3用）
void led3_thread(void const *args)
{
    while (true) {
        led3 = !led3;
        Thread::wait(400);
    }
}

//スレッド（LED4用）
void led4_thread(void const *args)
{
    while (true) {
        led4 = !led4;
        Thread::wait(200);
    }
}


//メイン
int main()
{
    Thread t2(led2_thread);
    Thread t3(led3_thread);
    Thread t4(led4_thread);
    while (true) {
//LED1は、メインの中にある特殊なスレッドと考えても良い。
        led1 = !led1;
        Thread::wait(1600);
    }
}