#include <mbed.h>
#include <mpr121.h>
#include "strings.h"

DigitalOut led1(LED1);

InterruptIn interrupt0(p8); //interrupt pin for touch0
InterruptIn interrupt1(p21); //interrupt for touch1

// Setup the i2c bus on pins 9 and 10
I2C i2c2(p9, p10); // I2C is used by both touch sensors
I2C i2c(p28, p27); // I2C is used by both touch sensors

Mpr121 touch1(&i2c, Mpr121::ADD_VSS);//setup touch1 address for vdd
Mpr121 touch0(&i2c2, Mpr121::ADD_VSS);//setup touch0 address for vss


//set serial port
Serial device(p13, p14);  // tx, rx

 int key_code0=0;
 int key_code1=0;


// Key hit/release interrupt routine for touch 0
void fallInterrupt0() {
  key_code0=0;
  char i=0;
  int value=touch0.read(0x00);
  value +=touch0.read(0x01)<<8;
  // LED demo mod
  i=0;
  // puts key number out to LEDs for demo
  for (i=0; i<12; i++) {
  if (((value>>i)&0x01)==1) key_code0+=1<<i;
  }


}


//fall interrupt for touch1
void fallInterrupt1() {

  key_code1=0;
  int i=0;
  int value=touch1.read(0x00);
  value +=touch1.read(0x01)<<8;
  // LED demo mod
  i=0;
  // puts key number out to LEDs for demo
  for (i=0; i<12; i++) {
  if (((value>>i)&0x01)==1) key_code1+=1<<i;
  }
  
}



int main() {
//device.printf("Starting \r\n");

char frompc=0;
  device.baud(115200); 
  interrupt0.fall(&fallInterrupt0);
  interrupt0.mode(PullUp);
  interrupt1.fall(&fallInterrupt1);
  interrupt1.mode(PullUp);


  while (1) {


  if(device.readable()){ //checks if ebox sends request
  frompc=device.getc();
  
  
    switch(frompc)//read character and check it
       {
        case '0':           //if character is '0' send key data from touch 0
            device.printf("%04d",key_code0);
            break;
        
        case '1':           //if character is '1' send key data from touch 1
            device.printf("%04d",key_code1);
            break;
           
        case 'A': //case for string value
            device.printf("%04d",Strings());
            break;
            
        default:
            break;
       }
       
  
  }
  }
}