#include "mbed.h"
#include "SDFileSystem.h"
#include "NokiaLCD.h"
#include "myBMP.h"
#include "mpr121.h"
#include "jpegutil.h"
#include <string>
#include <cctype>

SDFileSystem sd(p5, p6, p7, p8, "sd");
NokiaLCD lcd(p11, p13, p14, p15, NokiaLCD::LCD6610);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
InterruptIn interrupt(p26);
I2C i2c(p9,p10);
Mpr121 mpr121(&i2c, Mpr121::ADD_VSS);
Serial pc(USBTX,USBRX);
vector<string> files;
string file;
int selectpos = 1;
int oldvalue;
int value;
bool showingImage = false;
bool displayImage = false;


string toLower(string in)
{
    for(int i = 0; i < in.length(); i++)
    {
        in[i] = tolower(in[i]);
    }
    return in;
}

void changepos(int val2,int val1){ //compares the current position with the old one andchanges currsor accordingly.
//val1 is the lower value ond val2 th higher possibla value

if (!showingImage) {
                if (oldvalue==val1) {
                    if (selectpos != 1)
                    selectpos--;
                    // if (selectpos < 1)selectpos = files.size(); // no more raparround
                } else if(oldvalue==val2){
                    if (selectpos != files.size())
                    selectpos++;
                    //if (selectpos > files.size()) selectpos = 1; // no more raparound
                }
            }
}

void fallInterrupt() {
    value=mpr121.read(0x00);
    value +=mpr121.read(0x01)<<8;
    //pc.printf("%d\r\n",value);
    switch (value) {
        case 0: //no button is pressed (good only to execute actions on release)
                switch (oldvalue) { //if not do action according to button realeased.
                    case (1<<4):
                        if (showingImage) {
                            lcd.background(0xFFFFFF);
                            lcd.foreground(0xFFFFFF);
                            lcd.cls();
                            showingImage = false;
                        }
                        break;

                    case (1<<5):
                        if (!showingImage) {
                            displayImage = true;
                            showingImage = true;
                        }
                        break;
                
            }
            case 1:
            changepos(-1,3); //cannot have a lower value as 0 i no button
            break;
        case 3:
            changepos(1,2);
            break;
        case 2:
            changepos((2+1),(2+4));
            break;
        case (2+4):
            changepos(2,4);
            break;
        case 4:
            changepos((4+2),(4+8));
            break;
        case (4+8):
            changepos(4,8);
            break;
        case 8:
            changepos(4+8,-1); // cannot have a highe boundry
            break;

        default:

            break;
    };

    oldvalue=value;
}

void ls(char *dir)
{
    DIR *dp;
    struct dirent *dirp;
    dp = opendir(dir);
    while((dirp = readdir(dp)) != NULL)
    {
        files.push_back(string(dirp->d_name));
    }
}

int main() {
    interrupt.fall(&fallInterrupt);
    interrupt.mode(PullUp);
    
    lcd.background(0xFFFFFF);
    lcd.foreground(0xFFFFFF);
    lcd.cls();
    ls("/sd");
    
    led1 = 1;
    
    while(1) {
        int ypos = 1;
        if(displayImage)
        {
            __disable_irq();
            file = files[selectpos - 1];
            string ext = file.substr(file.rfind('.')+1);
            ext = toLower(ext);
            if(!ext.compare("bmp"))
            {
                RGBApixel *Colors = new RGBApixel [2];
                file = "/sd/" + file;
                lcd.background(0x000000);
                lcd.foreground(0x000000);
                lcd.cls();
                ReadBMPFromFile(file.c_str(), Colors, &lcd);
                showingImage = true;
            }
            else if(!ext.compare("jpeg") || !ext.compare("jpg"))
            {
                file = "/sd/" + file;
                lcd.background(0x000000);
                lcd.foreground(0x000000);
                lcd.cls();
                ReadJPEGFromFile(file.c_str(), &lcd);
                showingImage = true;
            }
            else
            {
                showingImage = false;
            }
            displayImage = false;
            __enable_irq();
        }
        if(!showingImage)
        {
            lcd.background(0xFFFFFF);
            lcd.locate(0,ypos);
            for(vector<string>::iterator it=files.begin(); it < files.end(); it++)
            {
                if(ypos == selectpos)
                {
                    lcd.foreground(0xFF0000);
                }
                else
                {
                    lcd.foreground(0x000000);
                }
                lcd.printf("%s",(*it).c_str());
                ypos++;
                lcd.locate(0,ypos);
            }
        }
        led1 = !led1;
        wait(0.05);
    }
}
