//Uses x & y acceleration to simulate a bubble level
//on the application board LCD display
#include "mbed.h"
#include "MMA7660.h"
#include "C12832.h"

C12832 lcd(p5, p7, p6, p8, p11); //On board LCD display
MMA7660 MMA(p28, p27); //I2C Accelerometer
//Serial pc(USBTX, USBRX);
//DigitalOut connectionLed(LED1);//Accel OK LED
BusOut myleds(LED1, LED2, LED3, LED4);

int pow(int x) {
    int pow = 1;
    if(x == 0) {
        return pow;
    }
    for(int i = 0; i < x; i++) {
        pow *= 2;
    }
    return pow;
}

void motion_detect() {
        if(MMA.y() < -0.5) {
            lcd.cls();
            lcd.locate(55,12);
            lcd.printf("UP");
            for(int i = 0; i < 4; i++) {
                myleds = pow(i);
                wait(0.05);
            }
            myleds = 0;
        }
        
        if(MMA.y() > 0.5) {
            lcd.cls();
            lcd.locate(55,12);
            lcd.printf("DOWN");
            for(int i = 3; i >= 0; i--) {
                myleds = pow(i);
                wait(0.05);
            }
            myleds = 0;
        }
        
        if(MMA.x() < -0.5) {
            lcd.cls();
            lcd.locate(55,12);
            lcd.printf("RIGHT");
            myleds = 6;
            wait(0.05);
            myleds = 9;
            wait(0.05);
            myleds = 0;
        }
        
        if(MMA.x() > 0.5) {
            lcd.cls();
            lcd.locate(55,12);
            lcd.printf("LEFT");
            myleds = 9;
            wait(0.05);
            myleds = 6;
            wait(0.05);
            myleds = 0;
        }
}
        
int main()
{
    lcd.cls(); //clear LCD screen
    if (MMA.testConnection())
        myleds = 15; //Accelerometer init OK
    while(1) {
        motion_detect();
    }
}
