//Uses x & y acceleration to simulate a bubble level
//on the application board LCD display
#include "mbed.h"
#include "MMA7660.h"
//#include "C12832_lcd.h"
#include "C12832.h"
#include "motion_detect.h"

#define LEFT 0
#define RIGHT 1
#define UP 2
#define DOWN 3

//static C12832_LCD lcd; //On board LCD display
static C12832 lcd(p5, p7, p6, p8, p11);
MMA7660 MMA(p28, p27); //I2C Accelerometer
//Serial pc(USBTX, USBRX);
//DigitalOut connectionLed(LED1);//Accel OK LED
BusOut myleds(LED1, LED2, LED3, LED4);

int pow(int x) {
    int pow = 1;
    if(x == 0) {
        return pow;
    }
    for(int i = 0; i < x; i++) {
        pow *= 2;
    }
    return pow;
}

void motion_detect(int &direction) {
        if(MMA.y() < -0.5) {
            if(direction != DOWN) {
                direction = UP;
            }
            for(int i = 0; i < 4; i++) {
                myleds = pow(i);
                wait(0.05);
            }
            myleds = 0;
        }
        
        if(MMA.y() > 0.5) {
            if(direction != UP) {
                direction = DOWN;
            }
            for(int i = 3; i >= 0; i--) {
                myleds = pow(i);
                wait(0.05);
            }
            myleds = 0;
        }
        
        if(MMA.x() < -0.5) {
            if(direction != LEFT) {
                direction = RIGHT;
            }
            myleds = 6;
            wait(0.05);
            myleds = 9;
            wait(0.05);
            myleds = 0;
        }
        
        if(MMA.x() > 0.5) {
            if(direction != RIGHT) {
                direction = LEFT;
            }
            myleds = 9;
            wait(0.05);
            myleds = 6;
            wait(0.05);
            myleds = 0;
        }
}
        
void validity() {
    lcd.cls(); //clear LCD screen
    if (MMA.testConnection())
        myleds = 15; //Accelerometer init OK
}
