#include <mbed.h>
#include "twi.h"
#include "PID.h"
#include "main.h"


//string support

// Object for custom I2C 
twi TWI;
//Led control
DigitalOut led3(LED3);
// objects for PID Controller
pid pid1(1,1,1, 30, 0,100);
pid pid2(-1,-1,-1, 30, 0,100);
//main object
main_support mains;

//global variables
double left_motor = 0.0;
double right_motor = 0.0;
int count = 0;


// wanted a setup that resembles an Arduino so newcomers can orient themselves quickly. 
// Main() = setup() and loop() = loop()
// Microcontroller starts here.

int main() {
    TWI.twi_init();
    
    //start loop
    mains.loop();
}
void main_support::loop(){
    // do everything continuously
    while(1){
        left_motor = pid1.PIDoutput(TWI.get_yaw());
        right_motor = pid2.PIDoutput(TWI.get_yaw());
        double out[] = {left_motor, right_motor};
        TWI.twi_RaspPi(out);
        
        blink();
    }   
}

void main_support::blink(){
    
        led3 = 1;
        wait(0.002);
        led3 = 0;
        wait(0.002);
}
