#ifndef PID_H
#define PID_H

//This is an attempt at a custom PID for thrusters on an submarine.

//This program was made with this reference - https://en.wikipedia.org/wiki/PID_controller
//And this reference https://github.com/br3ttb/Arduino-PID-Library
//And this reference http://brettbeauregard.com/blog/2011/04/improving-the-beginners-pid-introduction/

//I didn't want to just use the pre-build library because I want to understand what a PID is and how to use it.
//Plus I've had problems with code I didn't write myself before.

//Things to implement-
//                    automatic kp, ki, kd adjustment
//                    IMU reference input from MPU-6050
//                    Thruster adjustments (figure out how to implement PID values to the thruster)

class pid{

  public:
          pid();
          pid(double p, double i, double d, double desired, int minval, int maxval);
          double PIDoutput(double ref);
          void getReference(double ref);
          void updateDesired(double desired);
          double getref_IMU();
          
          double ref_IMU;
          float ref_IMUf;

  private:
          void setLimit(int minval, int maxval);
          void sampleTime(unsigned long sample);
          void setPIDTune(double kp, double ki, double kd);
          

          double kp;
          double ki;
          double kd;
          double kiTemp;
          double lastInput;


          int minv;
          int maxv;
          
          double setPoint;
          //tbd
  
};
#endif