#include "PID.h"

//#define DEBUG
//sets initial pid values and desired outcome value with the min and max values of the thrusters (0 - 100% or whatever we end up using)
pid::pid(){}

pid::pid(double p, double i, double d, double desired, int minval, int maxval){

    kp = p;
    ki = i;
    kd = d;

    setPoint = desired;

    setLimit(minval, maxval);
    
    
}
//This should be called every loop for the new output.
double pid::PIDoutput(double ref){

  double input = ref;
  ref_IMU = ref;
  double error = setPoint - input;
  kiTemp += (ki * error);

  if(kiTemp > maxv){
    kiTemp = maxv;
  }
  else if(kiTemp < minv){
    kiTemp = minv;
  }
  double di = (input - lastInput);

  //calculate the PID output (hopefully)

  double output = kp * error + kiTemp - kd * di;

  if(output > maxv){
    output = maxv;
  }
  else if(output < minv){
    output = minv;
  }

  //remember for later use
  lastInput = input;

  #ifdef DEBUG
    
  #endif

  return output;
    
}


void pid::updateDesired(double desired){

  setPoint = desired;
  
}

void pid::setLimit(int minval, int maxval){

  minv = minval;
  maxv = maxval;
  lastInput = 0;
  
}

void pid::getReference(double ref){
       
     //  if(ref > 179){
//          ref_IMU = ref * (360.00000000000/255.00000000000) ;// should return a value between 0 and 359. still need to alter it to be -180 - 180
//          ref_IMU -= 360.0;       // this should alter the number to be between -180 and 180 eg 359 - 360 = -1 and 181 - 360 = -179
//                                  // the only reason for the number change is it's easier to work with in terms of left and right.
//       }                          // left is negative right is positive
//       else{
//        ref_IMU = ref;
//       }
       ref_IMU = ref;    // returns a ##.0 because we don't need the decimals. there's no need for that much precision 
}

double pid::getref_IMU(){return ref_IMU;}
