#include "twi.h"
#include<mbed.h>

#define SDA p9
#define SCL p10
#define SLV_ADDR 0x10

#define DEBUG

I2CSlave slave(SDA,SCL);

DigitalOut led1(LED1);
DigitalOut led2(LED2);



void twi::twi_init(){
    slave.address(SLV_ADDR);
    slave.frequency(100000L);
    yaw = 0;
            
}
void twi::twi_RaspPi(double output[]){
    int i = slave.receive();
    while(1){
        switch(i){
            case I2CSlave::ReadAddressed:
                transmit(output);
                break;
            case I2CSlave::WriteAddressed:
                read_bus();
                break;
            case I2CSlave::WriteGeneral:
                transmit(output);
                break;  
            default: 
                if(led1 == 1){
                    
                    led1 = 0;
                    led1 = 1;
                }
                else{
                    led1 = 1;
                }
                break; 
        }
    }
        
}

void twi::transmit(double output[]){
    //get the size of the array to be transfered then convert it to a char array then transfer the char array over i2c. UNTESTED
    for(int i = 0; i < sizeof(output);i++){
        
        char buffer[10];
        sprintf (buffer, "%4.0f",output[i]);
        slave.write(buffer, strlen(buffer)+1);
        
    }
    //blink for indication of status
    led2 = 1;
    wait(0.002);
    led2 = 0;
    wait(0.002);
}

void twi::read_bus(){
    char buf[10];
    slave.read(buf, 10);
    
    double iPart = 0.0, dPart = 0.0, f = 0.0, mult = 0.1;
    char *p = (char*) buf;
    while(*p != '.') {
         iPart = iPart*10 + ((*(p++)-'0')); 
    }
    p++;
    while(*p!= '\0') {
         dPart += ((*(p++)-'0'))*mult;
         mult *= 0.1;
    }
    f = iPart + dPart; 
    yaw = f;  
    
    //blink for indication of status  
    led1 = 1;
    wait(0.002);
    led1 = 0;
    wait(0.002);
    
}

double twi::get_yaw(){return yaw;}