// Controller code
#pragma once
#include "mbed.h"
#include "CommandPool.h"
#include "Xbee.h"
#include "GenCMD.h"
#include "PinDetect.h"
#include "Mode.h"

GenCMD      gen_cmd;
Xbee        xbee(p9,p10,p11);
DigitalOut  led(LED1);
Mode        mode;
char        cmd_buffer = '\0';

Serial pc(USBTX,USBRX);

int main()
{
    gen_cmd.init();
    xbee.Reset();

    while(1)
    {
        if(mode.on)
        {
            gen_cmd.GenerateCMD(cmd_buffer);            
            xbee.Send(cmd_buffer);
            led = !led;  
        }    
        else
        {
            xbee.Send(STOP);
        }  
        
        wait(0.01);
    } 
 return 0;
}

/* Robot code 
#pragma once
#include "mbed.h"
#include "CommandPool.h"
#include "Xbee.h"
#include "GenCMD.h"

Command* cmd;
CommandPool pool;
GenCMD gen_cmd;
Xbee xbee(p9,p10,p11);
DigitalOut led(LED1);

char cmd_buffer='\0';

int main()
{
    pool.init();
    xbee.Reset();

    while(1)
    {
        xbee.Recv(cmd_buffer);
        pc.printf("%i\n",cmd_buffer);
        cmd = pool.getCommand(cmd_buffer);
        if(cmd)
        {
            cmd->execute();
        }
        led = !led;
        wait(0.01);  
    } 
 return 0;
}
*/
