#pragma once
#include "mbed.h"
#include "protocol.h"

// @author Stephane Rochon

class EasyVR
{
public:
    /** EasyVR use Serial communication*/
    EasyVR(PinName tx,PinName rx);              
    ~EasyVR();                                  
    
    /** Send a command to EasyVR to excute EasyVR build in routine*/
    void sendCmd(uint8_t);             
    
    /** Send a argument for the routine */
    void sendArg(int8_t);                       

    /** Receive return value from EasyVR routine */
    int8_t recv(int8_t timeOut = 1);         
       
    /** Decrypt returned value from EasyVR */
    void decrypt(char*);                        
    
    /** Used for awake EasyVR, default time out value to 100*/
    bool awake(int timeOut = 100);              
    
    
private:
    Serial _easyVR;
};