#include "mbed.h"
#include "EasyVR.h"
 
DigitalOut led1(LED1);
DigitalOut led4(LED4);

EasyVR VR(p13, p14);  // tx, rx
Serial pc(USBTX,USBRX);

PwmOut red(p21);
PwmOut blue(p22);
PwmOut green(p23);

void ledDance();
 
int main() {
    char buffer=0;

    if(VR.awake())                //wake up device - needs more work and a timeout
    {
        led1 = 1;
    }
    
    while (1)
    {
        VR.sendCmd(CMD_RECOG_SI); // Start Recognition
        VR.sendArg(1);            // Use Wordset 3 - the numbers 0..10
        
        buffer = VR.recv();       // Receive a byte from easyVR 
        
        if(buffer == CMD_SLEEP)   // If easyVR is sleeping
        {
            VR.sendCmd(' ');      // Send blanck to activate it
        }
        else
        {
            VR.decrypt(&buffer);  // If not sleeping, decrtpt received message
            pc.printf("%d\n",buffer);
        }
        
        // if command is taken by easyVR, the LED4 will toggle
        if (buffer==7) {red = 0; green = 1; blue = 0;led4=!led4;}   // hello
        if (buffer==6) {red = 0; green = 0; blue = 0;led4=!led4;}   // stop or turn off
        if (buffer==3) {led4=!led4;ledDance();}                     // run
        if (buffer==7) led4=!led4;
        wait(0.1);
    }
}

void ledDance()
{
    for(int i=0;i<5000;i++)
    {
        red = !green;
        green = !blue;
        blue = !red;
        wait(0.001);
    }
    red = 1;
    green = 0;
    blue = 0;
    
}