#include "mbed.h"
#include "SerialBuffered.h"
#include "globals.h"
#include "SDFileSystem.h"
#include "string.h"

#define SDWrite(STR) ((fp == NULL) ? fprintf(fp, STR) : errorled=1)

PwmOut Red(p25);
PwmOut Green(p23);
PwmOut Blue(p21);


SDFileSystem sd(p11, p12, p13, p10, "sd");
DigitalOut myled(LED1);
DigitalOut genled(LED2);
DigitalOut errorled(LED3);
DigitalOut successled(LED4);
Serial pc (USBTX,USBRX);
//FILE *fp = fopen("/sd/foo.txt", "w");




int main() {
    Red.period_us(100);
    Green.period_us(100);
    Blue.period_us(100);
    Red = 0;
    Green = 0;
    Blue = 0;

    int flushCount = 0;
    int fileStartTime = 0;

    errorled = 0;
    initAccel();

    while (devid == 0) {
        initAccel();
        pc.printf("devid=%u\n",devid);
    }
    pc.printf("devid=%u\n",devid);
    fp = fopen("/sd/clbr.txt", "a");
    int j = 0;
    while (j<6400) {
        if (accelRdy) {
            accelRdy = false;

            convertAccel;
            j++;
        }
    }
    pc.printf("NMEA data from LS20031:\n");
    char * pva_sent = (char *)calloc(255, sizeof(char));
    char * titlePath = (char *)calloc(255, sizeof(char));

    SerialBuffered *b = new SerialBuffered( 256, p28, p27);
    b->baud( 56000 );
    //only need to do this once to set up rmc
    //   char setup[] = "$PMTK314,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0*%x\r\n";
    // pc.printf("checksum : %x", checkSum(setup));
    // b->printf(setup, checkSum(setup));

    b->startReadStrings('\n');
    b->setTimeout( 0.1 );//stupid , shouldnt need this
    char* line[32];

    myled = 1;
    genled = 1;

    while (b->stringsAvailable()<=0); // we need to wait for gps string
    char * firstMsg = b->getString();
    while (!NMEA_parse(firstMsg)) {

        if (b->stringsAvailable()>0)
            firstMsg = b->getString();
    }
    while (b->stringsAvailable()>0) {
        firstMsg = b->getString();
        NMEA_parse(firstMsg);
    }

    myled = 0;
    genled = 0;

    fileStartTime = (int)timeG/10000;
    sprintf (titlePath, "/sd/%i_%i.txt",(int)date/10000 , (int)timeG/10000);
    pc.printf(titlePath);
    FILE *fp = fopen(titlePath, "a");

    while (fp == NULL) {
        wait (1);
        errorled = 1;
        successled = 1;
        genled = 1;
        myled = 1;
        wait(1);
        errorled = 0;
        successled = 0;
        genled = 0;
        myled = 0;
        if (b->stringsAvailable()>0) {
            firstMsg = b->getString();
            NMEA_parse(firstMsg);
        }
        fileStartTime = (int)timeG/10000;
        sprintf (titlePath, "/sd/%i_%i.txt",(int)date/10000 , (int)timeG/10000);
        fp = fopen(titlePath, "a");
    }

    pc.printf(titlePath);
    fprintf(fp,"break,\n");

    timer.start();
    while (1) {
        if (accelRdy) {
            accelRdy = false;
            convertAccel();
            sprintf (pva_sent,"A,%i,%f,%f,%f\n",accelTime,xaxis,yaxis,zaxis);
            // sprintf (pva_sent,"%f,%f,%f\n", xaxis,yaxis,zaxis);
            // pc.printf(pva_sent);
            fprintf(fp,pva_sent);
            Red = abs(yaxis);
            Blue = abs(zaxis);
            Green = abs(xaxis);
            successled = 1;
        }

        int i= 0;
        while (b->stringsAvailable()>0) {
            updateAccel();
            timer.reset();
            if (i<STRING_BUFFERS)
                line[i++] = b->getString();
            else
                break;
        }

        //    pc.printf("\n\navailable:%i\n", i); //if i>1 it would be a good idea to throw an error

        while (i>=1) {
            flushCount++;
            if (flushCount > 150) {

                flushCount = 0;
                fclose(fp);

                if (fileStartTime - (int)timeG/10000 != 0) {
                    fileStartTime = (int)timeG/10000;
                    if (date != 0)
                        sprintf (titlePath, "/sd/%i_%i.txt",(int)date/10000 , (int)timeG/10000);
                }
                fp = fopen(titlePath, "a");
                while (fp == NULL) {
                    wait (1);
                    errorled = 1;
                    successled = 1;
                    genled = 1;
                    myled = 1;
                    wait(1);
                    errorled = 0;
                    successled = 0;
                    genled = 0;
                    myled = 0;

                    fp = fopen(titlePath, "a");
                }

            }
            NMEA_parse(line[--i]);

            //sprintf (pva_sent,"\ngot line:%i\nDate:%f Time:%f Lat:%f Lon:%f Speed:%f Ax:%f Ay:%f Az:%f", i ,date,timeG,latitude,longitude,speed_knotts,xaxis,yaxis,zaxis);
            sprintf (pva_sent,"G,%i,%f,%f,%f,%f,%f,%f,%f\n",(int)date,timeG,latitude,longitude,speed_knotts,xaxis,yaxis,zaxis);
            //  pc.printf(pva_sent);
            successled = 1;
            fprintf(fp,pva_sent);
            successled = 0;
            //pc.printf("A X=%f, Y=%f, Z=%f\n",xaxis,yaxis,zaxis);

        }


    }
}



