
#include "GPS_LS20031.h"
#include "mbed.h"



char checkSum(char* theseChars) {
    char check = 0;
    // iterate over the string, XOR each byte with the total sum:

    for (int c = 1;theseChars[c]!= '*'; c++) {
        check = char(check ^ theseChars[c]);
    }
    // return the result
    return check;
}

bool NMEA_parse(char *msg) {
    char ns, ew,av;
    float magVar;


    // Check if it is a GPGGA msg (matches both locked and non-locked msg)
    if (sscanf(msg, "$GPRMC,%f,%c,%f,%c,%f,%c,%f,%f,%f", &timeG, &av, &latitude, &ns, &longitude, &ew, &speed_knotts, &magVar, &date) >= 1) {
        if (av == 'A') {
            if (ns == 'S') {
                latitude  *= -1.0;
            }
            if (ew == 'W') {
                longitude *= -1.0;
            }
            return true;
            /*  float degrees = trunc(latitude / 100.0f);
              float minutes = latitude - (degrees * 100.0f);
              latitude = degrees + minutes / 60.0f;
              degrees = trunc(longitude / 100.0f);  //a term had to be removed from this line
              minutes = longitude - (degrees * 100.0f);
              longitude = degrees + minutes / 60.0f;*/
        }
         else {
            longitude = 0.0;
            latitude = 0.0;
            return false;
        }

    }
    return false;

}