#include "ACCEL_ADXL345.h"
#include "mbed.h"

void accel_ISR() {
    accelRdy = true;
    accelTime = timer.read_us();
    updateAccel();
}

void updateAccel() {
  
    __disable_irq();// if we are interrupted here i could mean we get accel data from 2 different samples
    _cs = 0;
    _spi.write(0xF2);   // Read X out reg and have it continue for 6 bytes
    xraw0 =  _spi.write(0x0);
    xraw1 =  _spi.write(0x0);
    yraw0 =  _spi.write(0x0);
    yraw1 =  _spi.write(0x0);
    zraw0 =  _spi.write(0x0);
    zraw1 =  _spi.write(0x0);
    _cs = 1;
    __enable_irq();
    
    //pc.printf(" X1=%i, X0=%i, Y1=%i, Y0=%i, Z1=%i, Z0=%i, \n",xraw1,xraw0,yraw1,yraw0,zraw1,zraw0);

    //   pc.printf("%d %d %d",xaxis,yaxis,zaxis);
}

void convertAccel(){
  xaxis = (float)(xraw0 | (xraw1 << 8))/250.0;//(((xraw1 & 0x01) | ((xraw1&0x01)<<3) )<< 8));
  yaxis = (float)(yraw0 | (yraw1 << 8))/250.0;//(((yraw1 & 0x01) | ((yraw1&0x01)<<3) ) << 8));
  zaxis = (float)(zraw0 | (zraw1 << 8))/250.0;//(((zraw1 & 0x01) | ((zraw1&0x01)<<3) ) << 8));

}


void initAccel() {

    // Taken from datasheet
    // 8 bit data
    // High steady state clock
    // Second edge capture
    _spi.format(8,3);

    // 5MHz clock rate
    _spi.frequency(1000000);

    // Select the device, active low chip select
    _cs = 0;

    _spi.write(0x31); // set data_format to 0b00000001 to turn on 4 wire mode with act high interrupts,10 bit mode and +- 4g operation
    _spi.write(0x0B);
    // end this transfer
    _cs = 1;


    wait (0.01); //this is stupid, get rid of it


// new transfer
    _cs = 0;

    _spi.write(0x5D); // start writing at 0x1D but turn on sequential writes so we can set everything in one fowl swoop

    _spi.write(0xFF);  // set THRESH_TAP - only used when corresponding interrupt is enabled
    _spi.write(0x00); // set OFSX
    _spi.write(0x00); // set OFSY
    _spi.write(0x00); // set OFSZ
    _spi.write(0xFF); // set DUR (min duration to be considered a TAP event)
    _spi.write(0x00); // set Latent (max duration between TAP events)
    _spi.write(0x00); // set Window (max time after a Latency to be in the same TAP window)
    _spi.write(0x00); // set THRESH_ACT - only used when corresponding interrupt is enabled
    _spi.write(0x00); // set THRESH_INACT - only used when corresponding interrupt is enabled
    _spi.write(0xFF); // set TIME_INACT - only used when corresponding interrupt is enabled
    _spi.write(0x00); // set ACT_INACT_CTL - AC/DC coupling for activity registers + enabling/disabling in x,y.z - only used when corresponding interrupt is enabled
    _spi.write(0xFF); // set THRESH_FF (free fall) - only used when corresponding interrupt is enabled
    _spi.write(0xFF); // set TIME_FF (free fall)
    _spi.write(0x00); // set TAP_AXES (with 0x00 we are disabling all tap detection)
    // end this transfer
    _cs = 1;

// start another multiple byte transfer
    _cs = 0;
    _spi.write(0x6C); // another sequential write starting at 0x2C
    _spi.write(0x0E); // set BW_RATE to disable low power and turn on max bandwidth
    _spi.write(0x0B); // set // set PWR_CTRL to start measurments, and not be asleep , and to do 8hz measurements if asleep
    _spi.write(0x00); // set INT_ENABLE
    _spi.write(0x00); // set INT_MAP - send all interrupts to INT1 but doesnt really matter because we wont use this (yet)
    _cs = 1;

    // start new transfer
    _cs = 0;
    _spi.write(0x38); // FIFO_CTL
    _spi.write(0x00); // disable the FIFO
    _cs = 1;

    _cs = 0;
    _spi.write(0x80);
    wait(.1);
    devid = _spi.write(0x0);
    _cs  = 1;
    accel.attach_us(&accel_ISR, 625);
    accelRdy = false;
}
