/* This program executes an audio to rgb light conversion.
 * It is made for an international EESTEC Workshop by LC Hamburg.
 * This works on mbed LPC1768 with hardware peripherals on pcb.
 * It converts a stereo (to chan. mixed to mono) signal to light animation
 * Using digital filters or any alogrithm you prefer to convert music into ligth
 * It controlls 3 RGB LED stripes powerlines with 74HC595 shift
 * register.
 * 
 * Project:         DiscoTech
 * HDK/ SDK Eng:    Tobias Wulf
 * Date:            21.09.2013
 *
 */
 
#include "mbed.h"
#include "Terminal.h"


#include "adc.h"
#include "PwmDAC.h"
#include "ShiftReg.h"


#define SAMPLE_RATE 48000 //Hz
#define ADC_BIAS 1.65 //Volts
#define ULSB 3.3 / 4095
#define RESOLUTION 256

#define MASK 0x07 // for shift register


#define NUMBER_OF_SAMPLES 1024

/* declair your functions
 * isr routine doesn't have to be declaired
 */
void mainInit();


PwmDAC rgb;
ADC adc(SAMPLE_RATE, 1);
//AnalogOut dac(p18);
ShiftReg LEDstripes(p30, p29, p28);

/* Serial communication via usb uplink to pc
 * to display what ever you want in the terminal
 * or to send what ever you want from the terminal
 */
Terminal usbPC(USBTX, USBRX);

/* array for updating the PwmDAC object
 * and pointers for easy work
 * we use steps 1 3 5 ...point'em
 */
uint32_t channels[6];



/* global variables to work in the adc interrupt
 * service routine to get the data from interrupt
 */

unsigned int pattern;
double newSample;


bool save;

double adcSavings[NUMBER_OF_SAMPLES];
double adcSamples[NUMBER_OF_SAMPLES];



    double adcSample;
    // LP for output pwm channel 1
    const double b1[3] = {0.034566506326168603, 0.069133012652337206, 0.034566506326168603}; 
    const double a1[2] = { -1.5156844350566925,  0.65395046036136695}; 
    double w1[3];
    double y1;


int main() {

 
        // init for saving samples and filter results
        for (int i = 0; i < NUMBER_OF_SAMPLES; i++){
        adcSavings[i] = 0.0f;  
        adcSamples[i] = 0.0f;
        }
    

    // LP for output pwm channel 1
    for(int i= 0; i<3;i++)
        w1[i] = 0.0f;
    y1 = 0.0f;


 
    
    usbPC.printf("...start program\n");
    wait(0.2);

    mainInit();
    usbPC.printf("...init completed\n");
    wait(0.2);

 
    while(1) {
        
        if(save == false) {
        
           usbPC.locate(0,0);
           usbPC.cls();
           
           
           for(int i=0; i<NUMBER_OF_SAMPLES; i++)
                usbPC.printf("%1.4f %1.4f\n",adcSavings[i],adcSamples[i]);
        }
        
        if(save == false) break;
        
    }        

}/* end main */








/* interrupt service routine from adc object
 * here should be done the data processing
 * variable and output updates
 */
void getADC(int chan, uint32_t value) {
    static int cycleCounter = 0;
    
    adcSample = (double) adc.read(p15);
    adcSample = adcSample * ULSB;
              // first LP, chan 1 (red)
            w1[0] = adcSample - (a1[0] * w1[1]) - (a1[1] * w1[2]);
            y1 = 0.89125093813374 * ((b1[0] * w1[0]) +(b1[1] * w1[1]) + (b1[2] * w1[2]));
            w1[2] = w1[1]; 
            w1[1] = w1[0];
       
     if(cycleCounter < NUMBER_OF_SAMPLES) {
       adcSavings[cycleCounter] = y1;
       adcSamples[cycleCounter] = adcSample;
       cycleCounter++;
       if((cycleCounter == NUMBER_OF_SAMPLES-1) && save) {
            save = false;
            cycleCounter = 0;
       }
    }          
 
}         

/* function to initialize the main program, objects and 
 * implement all variables
 */
void mainInit() {
      


    for(int i=0; i<6; i++) {
        channels[i] = 0;
    }
        

    usbPC.printf("...variables implemented\n");
    wait(0.2);
    
    /* setup shift register (stripe power)
     */
     LEDstripes.ShiftByte((unsigned int) MASK, ShiftReg::MSBFirst);
     LEDstripes.Latch();
     wait(0.2);
    
    usbPC.printf("...shift register initialized\n");
    wait(0.2);
    
    /* setup adc input
     */
    adc.append(getADC);
    
    adc.startmode(0,0);
    adc.burst(1);
   
    adc.setup(p15,1);
    adc.setup(p16,0);
    adc.setup(p17,0);
    adc.setup(p18,0);
    adc.setup(p19,0);
    adc.setup(p20,0);
    
    wait(0.2);
    adc.interrupt_state(p15,1);
    
  
    
    
    usbPC.printf("%u, %u, %u, %u\n", adc.setup(p15), 
                                     adc.burst(),
                                     adc.interrupt_state(p15), 
                                     adc.actual_sample_rate());   
    
    usbPC.printf("...ADC initialized\n");
    wait(0.2);
    
    /* setup pwm output
     */
    rgb.init();
    rgb.deactivate(0);
    rgb.deactivate(2);
    rgb.deactivate(4);
    rgb.setResolution(RESOLUTION);
    rgb.start();
    
    usbPC.printf("...PWM output initialized\n");
    wait(0.2);
}