#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Begin.h"

N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad pad;
Begin beg;

void init();
void welcome();
void loading();
void game();

int main() {
    while(1){
        init();
        welcome();
        loading();
        while(pad.check_event(Gamepad::BACK_PRESSED) == false)  {
            game();
        }
    }
}

void init() {
    lcd.init();
    pad.init();
    beg.init();
    }
    
void welcome() {
    lcd.clear();
    lcd.printString("  FlappyBird! ",0,1);  
    lcd.printString("  Press Start ",0,4);
    lcd.refresh();
     
    // wait flashing LEDs until start button is pressed 
    while ( pad.check_event(Gamepad::START_PRESSED) == false) {
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }
 
}

void loading(){
    lcd.clear();
    lcd.printString("   READY!!!     ",0,3);
    lcd.refresh();
    wait_ms(500);
    lcd.clear();
    lcd.printString("     3     ",0,3);
    lcd.refresh();
    wait_ms(500);
    lcd.clear();
    lcd.printString("     2     ",0,3);
    lcd.refresh();
    wait_ms(500);
    lcd.clear();
    lcd.printString("     1     ",0,3);
    lcd.refresh();
    wait_ms(500);
    lcd.clear();
    lcd.printString("     GO!!!     ",0,3);
    lcd.refresh();
    wait_ms(500);
}

void game()
{
    lcd.clear();
    int d = beg.draw(lcd, pad);
    if(d == 1) {
        while(1) {
            init();
            welcome();
            loading();
            while(pad.check_event(Gamepad::BACK_PRESSED) == false)  {
                game();
            }
        }
    }
    lcd.refresh();
    wait(0.5);
}