#include "mbed.h"
#include "N5110.h"
#include "Bitmap.h"
#include "Gamepad.h"


N5110 lcd(PTC9, PTC0, PTC7, PTD2, PTD1, PTC11);
Gamepad pad;

int sprite_data[] = {
    0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,
    0,0,1,1,1,1,1,0,
    0,0,0,0,1,0,0,0,
    0,0,0,1,1,1,0,0,
    0,0,1,1,1,1,1,0,
    1,1,1,1,1,1,1,1,
    1,1,1,1,1,1,1,0,
    0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,
    };
void init();
void game();
void welcome();

int main() 
{
    init();
    lcd.normalMode();
    lcd.setBrightness(0.3);
    lcd.setContrast(0.5);
    while(1){
        welcome();
        if(pad.check_event(Gamepad::START_PRESSED) == true) {
            game();
        }
        wait(0.5);
    }
}

void init() {
    lcd.init();
    pad.init();
}
    
void welcome() {
    lcd.clear();
    lcd.printString("    COPTER   ",0,2);
    lcd.printString("  Press start",0,4);
    lcd.refresh();
    wait(0.3);
}

void game() {
    lcd.clear();
    lcd.printString("   READY!!!     ",0,3);
    lcd.refresh();
    wait_ms(500);
    lcd.clear();
    lcd.printString("     3     ",0,3);
    lcd.refresh();
    wait_ms(500);
    lcd.clear();
    lcd.printString("     2     ",0,3);
    lcd.refresh();
    wait_ms(500);
    lcd.clear();
    lcd.printString("     1     ",0,3);
    lcd.refresh();
    wait_ms(500);
    lcd.clear();
    lcd.printString("     GO!!!     ",0,3);
    lcd.refresh();
    wait_ms(500);
    int a1 = 20;
    int a2 = 20;
    int a3 = 20;
    int a4 = 20;
    int b1 = 20;
    int b2 = 20;
    int b3 = 20;
    int b4 = 20;
    int n = 0;
    while(pad.check_event(Gamepad::BACK_PRESSED) == false) {
        lcd.clear();
        int num1 = rand() % 10 + 5;
        int num2 = rand() % 6 + 14;
        a1 = a2;
        a2 = a3;
        a3 = a4;
        a4 = num1;
        b1 = b2;
        b2 = b3;
        b3 = b4;
        b4 = num2;
        Vector2D coord = pad.get_coord();
        int h = 17 * coord.y;
        Bitmap sprite(sprite_data, 10, 8);
        sprite.render(lcd,1,15-h);
        char buffer1[4];
        sprintf(buffer1,"score: %2d ",n);
        lcd.printString(buffer1,0,0);
        lcd.drawRect(0,8,84,40,FILL_TRANSPARENT);
        lcd.drawRect(0,8,21,b1-a1,FILL_BLACK);
        lcd.drawRect(0,8+b1+a1,21,40-b1-a1,FILL_BLACK);
        lcd.drawRect(21,8,21,b2-a2,FILL_BLACK);
        lcd.drawRect(21,8+b2+a2,21,40-b2-a2,FILL_BLACK);
        lcd.drawRect(42,8,21,b3-a3,FILL_BLACK);
        lcd.drawRect(42,8+b3+a3,21,40-b3-a3,FILL_BLACK);
        lcd.drawRect(63,8,21,b4-a4,FILL_BLACK);
        lcd.drawRect(63,8+b4+a4,21,40-b4-a4,FILL_BLACK);
        int d = 8 + b1 - a1;
        int e = 8 + b1 + a1;
        if(d >= 17-h | e <= 23-h){
            while(1){
                welcome();
                if(pad.check_event(Gamepad::START_PRESSED) == true) {
                    game();
                }
                wait(0.5);
            };
        };
        n = n + 10;
        lcd.refresh();
        wait(1);
    }
}