#ifndef COPTER_H
#define COPTER_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Bitmap.h"

/**  Copter class

*@brief Library to draw the copter
*@author Wu Aiming
*@date May 2019
*/

class Copter
{
public:

    /**Constructor*/
    Copter();
    /**Destructor*/
    ~Copter();
    /**
    *@brief Initialise all parameters of the Copter
    */
    void init();
    /** Gets raw cartesian co-ordinates of joystick
    *@param pad
    *@returns a struct with x,y members, each in the range 0.0 to 1.0
    */
    Vector2D get_coord(Gamepad &pad);
    /**
    *@brief Draw the bird
    *@param lcd
    *@details Use the method to use function within N5110.h file
    */
    void draw(N5110 &lcd);
    /**
    *@brief Get the live score
    *@return The live score
    */
    int get_score();
    /**
    *@brief Get the position of copter
    *@return The position of copter
    */
    int get_h();

private:

    int _score;
    int _h;
    Vector2D _ans;
};
#endif

