#ifndef GAME1_H
#define GAME1_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Wall.h"
#include "Copter.h"

/**  Game1 class

*@brief Library to combine the Copter and Wall
*@author Wu Aiming
*@date May 2019
*/

class Game1
{
public:

    /**Constructor*/
    Game1();
    /**Destructor*/
    ~Game1();
    /**
    *@brief Initialise all parameters of the Game1
    */
    void init();
    /**
    *@brief Draw the copter, wall and live scores
    *@param lcd, pad
    *@returns The number to test whether the copter crash the wall
    *@details Use the method to use function within N5110.h and Gamepad.h file
    */
    int draw(N5110 &lcd, Gamepad &pad);
    /**
    *@brief Get the live score
    *@return The live score
    */
    int get_score();

private:
    
    int _m;
    int _s;
    int _a;
    int _b;
    int _c;
    Copter _Copter;
    Wall _Wall;
};

#endif


