#ifndef BEGIN_H
#define BEGIN_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Wall1.h"
#include "Bird.h"

/**  Begin class

*@brief Library to combine the Bird and the Wall1
*@author Wu Aiming
*@date May 2019
*/

class Begin
{
public:

    /**Constructor*/
    Begin();
    /**Destructor*/
    ~Begin();
    /**
    *@brief Initialise all parameters of the Begin
    */
    void init();
    /**
    *@brief Draw the bird, wall1 and live scores
    *@param lcd, pad
    *@returns The number to test whether the bird crash the wall1
    *@details Use the method to use function within N5110.h and Gamepad.h file
    */
    int draw(N5110 &lcd, Gamepad &pad);
    /**
    *@brief Get the live score
    *@param lcd
    *@return The live score
    */
    int get_score(N5110 &lcd);

private:
    
    int _m;
    int _s;
    int _a1;
    int _b1;
    int _a2;
    int _b2;
    int _a3;
    int _b3;
    int _h;
    Bird _Bird;
    Wall1 _Wall1;
};

#endif


