#ifndef WALL1_H
#define WALL1_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/**  Wall1 class

*@brief Library to draw the thoroughfare of the flappy bird
*@author Wu Aiming
*@date May 2019
*/

class Wall1
{
public:
    
    /**Constructor*/
    Wall1();
    /**Destructor*/
    ~Wall1();
    /**
    *@brief Initialise all parameters of the Wall1
    */
    void init();
     /**
    *@brief Draw the thoroughfare of the flappy bird
    *@param lcd
    *@returns The boundary position of thoroughfare in (0,0) and live scores
    *@details Use the method to use function within N5110.h file
    */
    int* draw(N5110 &lcd);
    /**
    *@brief Input a mainfold
    */
    int* _ab;

private:

    int _a1;
    int _a2;
    int _a3;
    int _b1;
    int _b2;
    int _b3;
    int _score;
};

#endif