#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Game1.h"
#include "Begin.h"

N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad pad;
Game1 gam;
Begin beg;

void init();
void menu();
void welcome1();
void loading();
void game1();
void welcome2();
void game2();
void made();

int main() {
    while(1){
        init();
        menu();
        if(pad.check_event(Gamepad::Y_PRESSED) == true){
            while(pad.check_event(Gamepad::BACK_PRESSED) == false){
                init();
                welcome1();
                if(pad.check_event(Gamepad::START_PRESSED) == true) {
                    loading();
                    game1();
                }
                wait(0.1);
            }
        }
        if(pad.check_event(Gamepad::A_PRESSED) == true){
            while(pad.check_event(Gamepad::BACK_PRESSED) == false){
                init();
                welcome2();
                if(pad.check_event(Gamepad::START_PRESSED) == true) {
                loading();
                    game2();
                }
                wait(0.1);
            }
        }
        if(pad.check_event(Gamepad::B_PRESSED) == true){
            made();
        }
        wait(0.1);
    }
}

void init()
{
    lcd.init();
    pad.init();
    gam.init();
    beg.init();
}

void menu()
{
    lcd.clear();
    lcd.printString("Press button",0,0);
    lcd.printString("to select",0,1);
    lcd.printString("Y: Copter",0,2);
    lcd.printString("A: FlappyBird",0,3);
    lcd.printString("B: Made by",0,4);
    lcd.refresh();
    wait(0.3);
}

void made() 
{
    while(pad.check_event(Gamepad::BACK_PRESSED) == false){
        lcd.clear();
        lcd.printString(" Programme by:",0,1);
        lcd.printString("   Wu Aiming   ",0,2);
        lcd.printString("   201090185   ",0,3);
        lcd.printString("  2016110323   ",0,4);
        lcd.refresh();
        wait(0.5);
    }
}

void welcome1() {
    lcd.clear();
    lcd.printString("   Copter!    ",0,1);  
    lcd.printString("  Press Start ",0,4);
    lcd.refresh();
     
    pad.leds_on();
    wait(0.1);
    pad.leds_off();
    wait(0.1);
 
}

void loading(){
    lcd.clear();
    lcd.printString("   READY!!!     ",0,3);
    lcd.refresh();
    wait_ms(500);
    lcd.clear();
    lcd.printString("     3     ",0,3);
    lcd.refresh();
    wait_ms(500);
    lcd.clear();
    lcd.printString("     2     ",0,3);
    lcd.refresh();
    wait_ms(500);
    lcd.clear();
    lcd.printString("     1     ",0,3);
    lcd.refresh();
    wait_ms(500);
    lcd.clear();
    lcd.printString("     GO!!!     ",0,3);
    lcd.refresh();
    wait_ms(500);
}

void game1()
{
    while(pad.check_event(Gamepad::BACK_PRESSED) == false)  {
        lcd.clear();
        int d = gam.draw(lcd, pad);
        if(d == 1) {
            int s = gam.get_score();
            lcd.clear();
            lcd.printString("Your score is", 0, 2);
            char buffer2[14];
            sprintf(buffer2,"       %2d ",s);
            lcd.printString(buffer2,2,4);
            lcd.refresh();
            wait(1);
            break;
        }
        lcd.refresh();
        wait(0.8);
    }
}

void welcome2() {
    lcd.clear();
    lcd.printString("  FlappyBird! ",0,1);  
    lcd.printString("  Press Start ",0,4);
    lcd.refresh();
     
    pad.leds_on();
    wait(0.1);
    pad.leds_off();
    wait(0.1);
 
}

void game2()
{
    while(pad.check_event(Gamepad::BACK_PRESSED) == false)  {
        lcd.clear();
        int d = beg.draw(lcd, pad);
        if(d == 1) {
            int s = beg.get_score(lcd);
            lcd.clear();
            lcd.printString("Your score is", 0, 2);
            char buffer2[14];
            sprintf(buffer2,"      %2d ",s);
            lcd.printString(buffer2,2,4);
            lcd.refresh();
            wait(1);
            break;
        }
        lcd.refresh();
        wait(0.3);
    }
}